App.config(['$stateProvider', '$urlRouterProvider', '$locationProvider', 'settings', 'routeProvider', 'pathProvider', 'authProvider', '$ocLazyLoadProvider', '$showdownProvider', '$urlMatcherFactoryProvider',
    function ($stateProvider, $urlRouterProvider, $locationProvider, settings, routeProvider, pathProvider, authProvider, $ocLazyLoadProvider, $showdownProvider, $urlMatcherFactoryProvider) {

        /**
         * Config Modules
         *
         * Route, Path, Auth, ocLazyLoad, Location, Showdown
         */
        routeProvider.config(settings.route);

        pathProvider.config(settings.path);

        authProvider.config(settings.auth);

        $ocLazyLoadProvider.config({
            debug: true
        });

        $locationProvider.html5Mode({
            enabled: true,
            requireBase: false
        });

        $showdownProvider.loadExtension('prettify');

        // Url contains a trailing slash or not
        $urlMatcherFactoryProvider.strictMode(false);

        // Namespace used for define route.
        var namespace = '/' + settings.route.namespace;

        $stateProvider
            .state('home', {
                url: "/",
                templateUrl: namespace + "/home",
                data: {
                    title: 'Home',
                    description: 'MEANStack.io bringing together the best of MEAN MongoDB, Express, AngularJS and Node.js'
                },
                controller: "homeController",
                resolve: {
                    deps: ['$ocLazyLoad', 'path', function ($ocLazyLoad, path) {
                        return $ocLazyLoad.load({
                                insertBefore: '#load_js_before',
                                files: [
                                    path.controller('homeController')
                                ]
                            }
                        );
                    }]
                }
            })

            .state('about', {
                url: "/about",
                templateUrl: namespace + "/about",
                data: {title: 'About'},
                controller: "aboutController",
                resolve: {
                    deps: ['$ocLazyLoad', 'path', function ($ocLazyLoad, path) {
                        return $ocLazyLoad.load({
                                insertBefore: '#load_js_before',
                                files: [
                                    path.controller('aboutController')
                                ]
                            }
                        );
                    }]
                }
            })

            .state('releases', {
                url: "/releases/:page",
                params: {
                    page: {
                        value: "1",
                        squash: true
                    }
                },
                templateUrl: namespace + "/release",
                data: {title: 'Releases'},
                controller: "releaseController",
                resolve: {
                    deps: ['$ocLazyLoad', 'path', function ($ocLazyLoad, path) {
                        return $ocLazyLoad.load(
                            {
                                insertBefore: '#load_js_before',
                                files: [
                                    path.controller('releaseController')
                                ]
                            }
                        );
                    }],
                    releasesPageResource: ['releaseService', '$stateParams', function (releaseService, $stateParams) {
                        return releaseService.query(
                            {
                                action: 'load',
                                page: $stateParams.page
                            }
                        ).$promise;
                    }],
                    releasesResource: ['releaseService', function (releaseService) {
                        return releaseService.query(
                            {
                                action: 'load'
                            }
                        ).$promise;
                    }]
                }
            })

            .state('redirectDocs', {
                url: "/docs",
                resolve: {
                    releasesResource: ['releaseService', function (releaseService) {
                        return releaseService.query(
                            {
                                action: 'current'
                            }
                        ).$promise;
                    }]
                },
                controller: ['$state', 'releasesResource', function ($state, releasesResource) {
                    $state.go('docs', {release: releasesResource.data.version});
                }]
            })

            .state('docs', {
                url: "/docs/:release/:doc",
                params: {
                    release: {
                        value: null
                    },
                    doc: {
                        value: null,
                        squash: true
                    }
                },
                templateUrl: namespace + "/docs",
                data: {title: 'Documentation'},
                controller: "documentationController",
                resolve: {
                    deps: ['$ocLazyLoad', 'path', function ($ocLazyLoad, path) {
                        return $ocLazyLoad.load(
                            {
                                insertBefore: '#load_js_before',
                                files: [
                                    path.controller('documentationController')
                                ]
                            }
                        );
                    }],
                    documentationsResource: ['documentationService', '$stateParams', function (documentationService, $stateParams) {
                        return documentationService.query(
                            {
                                action: 'load',
                                release: $stateParams.release,
                                doc: $stateParams.doc
                            }
                        ).$promise;
                    }],
                    releasesResource: ['releaseService', function (releaseService) {
                        return releaseService.query(
                            {
                                action: 'load'
                            }
                        ).$promise;
                    }]
                }
            })

            .state('signin', {
                url: "/admin/signin?r?p",
                templateUrl: namespace + "/admin/signin",
                data: {title: 'Admin - Sign In'},
                controller: "adminSignInController",
                resolve: {
                    deps: ['$ocLazyLoad', 'path', function ($ocLazyLoad, path) {
                        return $ocLazyLoad.load({
                                insertBefore: '#load_js_before',
                                files: [
                                    path.controller('admin/adminSignInController')
                                ]
                            }
                        );
                    }]
                },
                access: {
                    auth: false
                }
            })

            .state('admin', {
                url: "/admin",
                templateUrl: namespace + "/admin",
                data: {title: 'Admin - Dashboard'},
                controller: "adminDashboardController",
                resolve: {
                    deps: ['$ocLazyLoad', 'path', function ($ocLazyLoad, path) {
                        return $ocLazyLoad.load({
                                insertBefore: '#load_js_before',
                                files: [
                                    path.controller('admin/adminDashboardController')
                                ]
                            }
                        );
                    }]
                },
                access: {
                    auth: true,
                    paramOfRedirect: false
                },
                cache: false
            })

            // ======== Release ========
            .state('admin-release', {
                url: "/admin/release",
                templateUrl: namespace + "/admin/release",
                data: {title: 'Admin - Releases'},
                controller: "adminReleaseController",
                resolve: {
                    deps: ['$ocLazyLoad', 'path', function ($ocLazyLoad, path) {
                        return $ocLazyLoad.load({
                                insertBefore: '#load_js_before',
                                files: [
                                    path.controller('admin/release/adminReleaseController')
                                ]
                            }
                        );
                    }]
                },
                access: {
                    auth: true
                }
            })

            .state('admin-release-create', {
                url: "/admin/release/create",
                templateUrl: namespace + "/admin/release/create",
                data: {title: 'Admin - New release'},
                controller: "adminReleaseCreateController",
                resolve: {
                    deps: ['$ocLazyLoad', 'path', function ($ocLazyLoad, path) {
                        return $ocLazyLoad.load([
                            {
                                insertBefore: '#load_js_before',
                                files: [
                                    path.controller('admin/release/adminReleaseCreateController')
                                ]
                            }
                        ]);
                    }]
                },
                access: {
                    auth: true
                }
            })

            .state('admin-release-edit', {
                url: "/admin/release/:release/edit",
                templateUrl: function (params) {
                    return namespace + "/admin/release/" + params.release + "/edit";
                },
                data: {title: 'Admin - Edit release'},
                controller: "adminReleaseEditController",
                resolve: {
                    deps: ['$ocLazyLoad', 'path', function ($ocLazyLoad, path) {
                        return $ocLazyLoad.load([
                            {
                                insertBefore: '#load_js_before',
                                files: [
                                    path.controller('admin/release/adminReleaseEditController')
                                ]
                            }
                        ]);
                    }]
                },
                access: {
                    auth: true
                }
            })

            // ======== Documentation ========
            .state('admin-documentation', {
                url: "/admin/documentation",
                templateUrl: namespace + "/admin/documentation",
                data: {title: 'Admin - Documentations'},
                controller: "adminDocumentationController",
                resolve: {
                    deps: ['$ocLazyLoad', 'path', function ($ocLazyLoad, path) {
                        return $ocLazyLoad.load({
                                insertBefore: '#load_js_before',
                                files: [
                                    path.controller('admin/documentation/adminDocumentationController')
                                ]
                            }
                        );
                    }]
                },
                access: {
                    auth: true
                }
            })

            .state('admin-documentation-create', {
                url: "/admin/documentation/create",
                templateUrl: namespace + "/admin/documentation/create",
                data: {title: 'Admin - New documentation'},
                controller: "adminDocumentationCreateController",
                resolve: {
                    deps: ['$ocLazyLoad', 'path', function ($ocLazyLoad, path) {
                        return $ocLazyLoad.load([
                            {
                                insertBefore: '#load_js_before',
                                files: [
                                    path.controller('admin/documentation/adminDocumentationCreateController')
                                ]
                            }
                        ]);
                    }]
                },
                access: {
                    auth: true
                }
            })

            .state('admin-documentation-edit', {
                url: "/admin/documentation/:documentation/edit",
                templateUrl: function (params) {
                    return namespace + "/admin/documentation/" + params.documentation + "/edit";
                },
                data: {title: 'Admin - Edit documentation'},
                controller: "adminDocumentationEditController",
                resolve: {
                    deps: ['$ocLazyLoad', 'path', function ($ocLazyLoad, path) {
                        return $ocLazyLoad.load([
                            {
                                insertBefore: '#load_js_before',
                                files: [
                                    path.controller('admin/documentation/adminDocumentationEditController')
                                ]
                            }
                        ]);
                    }]
                },
                access: {
                    auth: true
                }
            })

            .state('404', {
                templateUrl: namespace + "/error/404",
                data: {title: 'Page not found'}
            })

            .state('403', {
                templateUrl: namespace + "/error/403",
                data: {title: 'Not authorized'}
            })

            .state('500', {
                templateUrl: namespace + "/error/500",
                data: {title: 'Internal server error'}
            });


        $urlRouterProvider.otherwise(function ($injector, $location) {
            var state = $injector.get('$state');
            state.go('404');
            return $location.path();
        });
    }]);
