'use strict';

var express = require('express'),
    router = express.Router(),
    Documentation = require('app/models/documentation').Documentation,
    auth = require('modules/auth'),
    requestDocumentation = require('app/http/requests/admin/documentation');

// Routes require authentication.
router.use(auth.isAuthenticated);

// Index
router.get('/', function (req, res) {
    res.render('admin/documentation/index');
});

// List
router.post('/list', function (req, res) {
    var data = req.body,
        conditions = (typeof data.conditions !== ' undefined') ? data.conditions : {},
        options = (typeof data.options !== ' undefined') ? data.options : {};

    if (typeof data.paginate !== 'undefined') {
        // {page: data.page, limit: 5, sort: {version: 'desc'}
        Documentation.paginate(conditions, data.paginate, function (err, documentations) {
            if (err) {
                return res.json(
                    req.response.return('Error loading documentations !')
                );
            }

            req.response.setSuccess();
            req.response.setData(documentations);
            return res.json(req.response.return());
        });
    } else {
        Documentation.find(conditions)
            .select(options.select)
            .sort(options.sort)
            .limit(options.limit)
            .exec(function (err, documentations) {
                if (err) {
                    return res.json(
                        req.response.return('Error loading documentations !')
                    );
                }

                req.response.setSuccess();
                req.response.setData({documentations: documentations});
                return res.json(req.response.return());
            });
    }
});

// Create
router.get('/create', function (req, res) {
    res.render('admin/documentation/create');
});

// Store
router.post('/', requestDocumentation, function (req, res) {

    var newDocumentation = new Documentation(req.body);

    newDocumentation.save(function (err) {
        if (err) {
            // Get errors.
            req.response.setMsg(err.errors, 'message');

            return res.json(
                req.response.return()
            );
        }

        req.response.setSuccess();
        return res.json(
            req.response.return('Documentation registered !')
        );
    });
});

// Edit
router.get('/:_id/edit', function (req, res) {
    return res.render('admin/documentation/edit');
});

// Load
router.post('/:_id/load', function (req, res) {
    Documentation.findOne({_id: req.params._id})
        .populate('releases')
        .exec(function (err, documentation) {
            if (err) {
                // Get errors.
                req.response.setMsg(err.errors, 'message');

                return res.json(
                    req.response.return()
                );
            }

            if (documentation) {
                req.response.setSuccess();
                req.response.setData({documentation: documentation});
            } else {
                req.response.setMsg("Documentation not found !");
            }

            return res.json(
                req.response.return()
            );
        });
});

// Update
router.put('/:_id', requestDocumentation, function (req, res) {

    // .findOneAndUpdate( not execute middleware updateAt
    Documentation.update({_id: req.params._id}, req.body, function (err) {
        if (err) {
            // Get errors.
            req.response.setMsg(err.errors, 'message');

            return res.json(
                req.response.return()
            );
        }

        req.response.setSuccess();
        return res.json(
            req.response.return('Documentation updated !')
        );
    });
});

// Delete
router.delete('/:_id', function (req, res) {
    var id = req.params._id;

    Documentation.findOne({_id: id}, function (err, documentation) {
        if (err) {
            return res.json(
                req.response.return('Error in finding the documentation.')
            );
        }

        if (!documentation) {
            return res.json(
                req.response.return('Documentation not found.')
            );
        }

        /**
         * Note: There is no query hook for remove(), only for documents. If you set a 'remove' hook, it will be fired
         * when you call myDoc.remove(), not when you call MyModel.remove().
         */
        documentation.remove(function (err) {
            if (err) {
                // Get errors.
                req.response.setMsg(err.errors, 'message');

                return res.json(
                    req.response.return()
                );
            }

            req.response.setSuccess();
            var msg = 'Documentation ' + documentation.title + ' deleted !';

            return res.json(
                req.response.return(msg)
            );
        });
    });
});

module.exports = router;
