'use strict';

var express = require('express'),
    router = express.Router(),
    Documentation = require('app/models/documentation').Documentation;

/*
 Method      Route                       Action      Return      Description                         Resource AngularJS
 GET         /article                    index       Html        Articles index.                     ---
 GET         /article/load               load        Action      Load articles.                      query({action: 'load'}... )
 GET	     /article/create             create      Html        Create article.                     ---
 POST        /article	                 store       Action      Store article.                      save(... )
 GET         /article/{article}          show        Html        Preview article.                    ---
 GET	     /article/{article}/edit	 edit        Html        Edit article.                       ---
 GET         /article/{article}/load     load        Action      Load article for show or edit.      get({article: article.id, action: 'load'}... )
 PUT/PATCH   /article/{article}          update      Action      Update article.                     update({article: article.id}... )
 DELETE      /article/{article}          destroy     Action      Delete article.                     delete({article: article.id}... )
 */

router.get('/', function (req, res) {
    res.render('documentation/index');
});

router.get('/:release/:doc/load', function (req, res) {

    Documentation.findOne({
        published: true,
        title: req.params.doc
    })
        .populate('releases')
        .exec(function (err, documentation) {
            if (err) {
                return res.status(500).json(
                    req.response.return('Error loading documentation !')
                );
            } else if (documentation.length === 0) {
                return res.status(404).json(
                    req.response.return('Documentation not found !')
                );
            }

            req.response.setData(documentation);
            req.response.setSuccess();
            return res.json(req.response.return());
        });
});

router.get('/:release/load', function (req, res) {

    Documentation.findByRelease(req.params.release, {select: '-_id title'}).then(function (documentation) {
        if (!documentation) {
            return res.status(404).json(
                req.response.return('Documentation not found !')
            );
        }

        req.response.setData(documentation);
        req.response.setSuccess();
        return res.json(req.response.return());
    }).catch(function () {
        return res.status(500).json(
            req.response.return('Error loading documentation !')
        );
    });
});

module.exports = router;
