'use strict';

var response = require('modules/response'),
    viewComposer = require('app/providers/view-composer'),
    cookieLogin = require('app/providers/cookie').login;

/**
 * Initialize middleware.
 *
 * @param app
 */
module.exports = function (app) {

    /**
     * View Composer.
     */
    app.use(viewComposer);

    /**
     * Initialize cookie for control login in AngularJS.
     */
    app.use(cookieLogin.init);

    /**
     * Module Response.
     */
    app.use(response());
};
