var validator = require('modules/validation');

var documentationRequest = function () {

    /**
     * Authorized access. [Optional]
     *   Default true.
     *
     * @param req
     * @returns {boolean}
     */
    this.authorized = function (req) {
        return req.isAuthenticated();
    };

    /**
     * Rules. [Required]
     *
     * @type {{version: string, description: string, publish: string}}
     */
    this.rules = {
        title: 'required|min:3|max:30',
        description: 'required|min:10',
        published: 'required|boolean',
        releases: 'required|object'
    };

    /**
     * Labels of attributes. [Optional]
     *
     * @type {{version: string, description: string, publish: string}}
     */
    this.labels = {
        version: 'version',
        description: 'description',
        published: 'publish',
        releases: 'releases'
    };

    /**
     * Messages. [Optional]
     *
     * @type {{required: string, min: string, boolean: string}}
     */
    this.message.required = 'Please :attribute is required !';
};

module.exports = validator(documentationRequest);
