'use strict';

/**
 * app/providers/express
 *
 * Add methods
 *   Router().useController('/admin/account', 'admin.account'),
 *   Router().useViewAutoLoad('/view'),
 *   Router().controller('admin.account'),
 */
var namespace = require('app/providers/route').namespace,
    router = require('app/providers/express').Router();

/**
 * Initialize routes
 *
 * @param app
 */
module.exports = function (app) {

    /**
     * Routes namespace.
     * Namespace is configured in file config -> settings.route.namespace, default is api.
     *
     * Example url:
     *   /api/home
     *   /api/about
     *   /api/documentation
     *   ...
     */
    app.use(namespace(),
        router.useController('/home', 'home'),
        router.useController('/about', 'about'),
        router.useController('/docs', 'documentation'),
        router.useController('/release', 'release'),

        router.useController('/admin',
            [
                'admin.index',
                'admin.account'
            ]
        ),

        router.useController('/admin/release', 'admin.release'),
        router.useController('/admin/documentation', 'admin.documentation'),

        router.useController('/error', 'error'),

        // Send code status 404.
        router.use(function (req, res) {
            res.sendStatus(404);
        })
    );

    /**
     * Index.
     */
    app.all('*', router.controller('index'));
};
