'use strict';

var faker = require('faker'),
    Documentation = require('app/models/documentation').Documentation,
    Release = require('app/models/release').Release;

// Multiple register with faker.
var seed = function () {
    return Release.random({published: true}, {select: '_id'})
        .then(function (release) {
            return {
                title: (faker.lorem.words()).slice(0, 29),
                description: faker.lorem.paragraphs(),
                releases: [release._id],
                published: faker.random.boolean()
            }
        }).catch(function (e) {
            console.log(e);
        });
};

module.exports = {
    document: {
        data: seed,
        loop: 10
    },
    model: Documentation
};
