'use strict';

/**
 * Strategy local.
 */
var localStrategy = require('passport-local').Strategy,
    User = require('app/models/user').User;

/**
 * Strategy local sign in.
 */
module.exports.signIn = new localStrategy(
    {
        usernameField: 'email',
        passwordField: 'password'
    },
    function (email, password, done) {
        User.findOne({email: new RegExp('^' + email + '$', "i")})
            .exec()
            .then(function (user) {
                if (!user) {
                    return [false, {message: 'Incorrect email.'}];
                }
                else if (!user.comparePassword(password)) {
                    return [false, {message: 'Incorrect password.'}];
                }

                // Success
                return user;
            }).nodeify(done, {spread: true});
    }
);
