angular.module("App")
    .controller("adminReleaseCreateController", ['$scope', '$state', 'request', 'toaster', '$timeout', function ($scope, $state, request, toaster, $timeout) {

        $scope.onloadPretty = true;

        $scope.$watch('onloadPretty', function () {
            if ($scope.onloadPretty) {
                prettyPrint();
            }
        });

        $scope.$watch('release.description', function () {
            $timeout(function () {
                if ($scope.onloadPretty) {
                    prettyPrint();
                }
            });
        });

        /**
         * Init scope release.
         *
         * @type {{}}
         */
        $scope.release = {
            version: '',
            description: '',
            published: ''
        };

        $scope.action = function () {
            // Clear message.
            toaster.clear();

            request('admin/release').post(
                $scope.release,
                function (response) {
                    if (response.success) {
                        toaster.success("Success", response.msg.join('<br>'));

                        $state.go('admin-release');
                    } else {
                        toaster.error("Error", response.msg.join('<br>'));
                    }
                }
            );
        };
    }]);
