angular.module("App")
    .controller("adminReleaseEditController", ['$scope', '$state', 'request', 'toaster', '$stateParams', '$timeout', function ($scope, $state, request, toaster, $stateParams, $timeout) {

        $scope.onloadPretty = true;

        $scope.$watch('onloadPretty', function () {
            if ($scope.onloadPretty) {
                prettyPrint();
            }
        });

        $scope.$watch('release.description', function () {
            $timeout(function () {
                if ($scope.onloadPretty) {
                    prettyPrint();
                }
            });
        });

        /**
         * Init scope release.
         *
         * @type {{}}
         */
        $scope.release = {
            version: '',
            description: '',
            published: ''
        };

        // Load release.
        request('admin/release/' + $stateParams.release + '/load').post(
            {},
            function (response) {
                if (response.success) {
                    var release = response.data.release;
                    $scope.createdAt = moment(release.createdAt).format('DD/MM/YYYY hh:mm');
                    $scope.updatedAt = moment(release.updatedAt).format('DD/MM/YYYY hh:mm');

                    $scope.release.version = release.version;
                    $scope.release.description = release.description;
                    $scope.release.published = String(release.published);
                } else {
                    toaster.error("Error", response.msg.join('<br>'));
                    $state.go('admin-release');
                }
            }
        );

        $scope.action = function () {
            // Clear message.
            toaster.clear();

            request('admin/release/' + $stateParams.release).put(
                $scope.release,
                function (response) {
                    if (response.success) {
                        toaster.success("Success", response.msg.join('<br>'));

                        $state.go('admin-release');
                    } else {
                        toaster.error("Error", response.msg.join('<br>'));
                    }
                }
            );
        };
    }]);
