angular.module('App')
    .controller('releaseController', ['$scope', '$state', '$timeout', 'releasesPageResource', 'releasesResource', function ($scope, $state, $timeout, releasesPageResource, releasesResource) {

        $scope.$watch('releasesPage', function () {
            $timeout(function () {
                prettyPrint();
            });
        });

        $scope.releases = releasesResource.data;

        $scope.releasesPage = releasesPageResource.data.docs;

        $scope.pagination = {
            total: releasesPageResource.data.total,
            limit: releasesPageResource.data.limit,
            page: releasesPageResource.data.page
        };

        $scope.$watch('pagination.page', function (page) {
            page = (page == 1) ? null : page;
            $state.go('releases', {page: page});
        });
    }]);
