/**
 * Module load file path.
 *   controller,
 *   image,
 *   style,
 *
 * Example:
 *
 *   ...
 *   controller: 'homeController', //Controller page
 *   resolve: {
 *   //Load dependencies
 *   deps: ['$ocLazyLoad', 'path', function ($ocLazyLoad, path) {
 *       return $ocLazyLoad.load({
 *           //Insert controller before id
 *           insertBefore: '#load_controllers',
 *           files: [
 *               //Return controller path according destination and minify.
 *               path.controller('homeController')
 *           ]
 *       },
 *       ...
 *
 * === Config path directories in file ../config.js ===
 *
 *   ...
 *   path: {
 *       minifyFiles: true,
 *       controller: '/javascripts/',
 *       image: '/images/',
 *       style: '/stylesheets/'
 *   },
 *   ...
 *
 */

var AppPath = angular.module('AppPath', []);

AppPath.provider('path', [function () {
    var settings_default = {
            path: {
                minifyFiles: true,
                scripts: '/javascripts/',
                controllers: '/javascripts/',
                images: '/images/',
                styles: '/stylesheets/',
                libs: '/libs/'
            }
        },
        settings = {};

    this.config = function (op_settings) {
        settings = angular.extend(settings_default, op_settings);
    };

    this.$get = ['settings',
        function (settings) {
            var service = {},
                min = (typeof settings.path.minifyFiles === 'undefined' || settings.path.minifyFiles === true),
                extension = function (type) {
                    return ((min) ? '.min' : '') + '.' + type;
                };

            /**
             * Return controller path according destination and minify.
             *
             * @param controllerName
             * @returns {*}
             */
            service.controller = function (controllerName) {
                return settings.path.controllers + controllerName + extension('js');
            };

            service.script = function (script) {
                return settings.path.scripts + script + extension('js');
            };

            service.style = function (style) {
                return settings.path.styles + style + extension('css');
            };

            service.image = function (image) {
                return settings.path.images + image;
            };

            service.lib = function (lib) {
                return settings.path.libs + lib;
            };

            return service;
        }
    ];
}]);
