/**
 * Module Route.
 * Return route with namespace at application.
 *
 * Example:
 *   ['$resource', 'route', function ($resource, route) {
 *      return function (url) {
 *          return $resource(
 *              route.namespace(url),
 *              ...
 *
 *   route.namespace(), return '/api'
 *   route.namespace('/home'), return '/api/home'
 */
var AppRoute = angular.module('AppRoute', []);

AppRoute.provider("route", [function () {
    var settings_default = {
            route: {
                namespace: 'api'
            }
        },
        settings = {};

    this.config = function (op_settings) {
        settings = angular.extend(settings_default, op_settings);
    };

    this.$get = ['settings',
        function (settings) {
            var service = {};

            service.namespace = function (route) {
                if (typeof route === 'undefined') {
                    return '/' + settings.route.namespace;
                }
                return '/' + settings.route.namespace + '/' + route;
            };

            return service;
        }
    ];
}]);
