/**
 *  Init global settings and run the app
 */
App.run(["$rootScope", "settings", "$state", "auth", "path", function ($rootScope, settings, $state, auth, path) {
    // state to be accessed from view
    $rootScope.$state = $state;

    // settings to be accessed from view
    $rootScope.settings = settings;

    // load files in view
    $rootScope.path = path;

    // check auth to be accessed from view
    $rootScope.login = function () {
        return auth.check();
    };

    $rootScope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {

        //Route control access
        auth.routeAuth(event, $state, toState, toParams);

    });

    // if error handler go to page error angular.
    $rootScope.$on('$stateChangeError', function(event, toState, toParams, fromState, fromParams, error) {

        event.preventDefault();

        if(error.status === 404) {
            return $state.go('404');
        } else if(error.status === 403) {
            return $state.go('403');
        }

        return $state.go('500');
    });
}]);
