/**
 * Sample React Native App
 * https://github.com/facebook/react-native
 * @flow
 */

import React, { Component } from 'react';
import {
  Platform,
  StyleSheet,
  Text,
  View,
  NativeModules,
  Switch,TextInput
} from 'react-native';
import Button from 'react-native-button';
import HelloManager from './customModule';
//const HelloManager=NativeModules.HelloManager;

const instructions = Platform.select({
  ios: 'Press Cmd+R to reload,\n' +
    'Cmd+D or shake for dev menu',
  android: 'Double tap R on your keyboard to reload,\n' +
    'Shake or press menu button for dev menu',
});

type Props = {};
export default class App extends Component<Props> {

  componentWillMount(){
    this.setState({
      greetingMessage:undefined
    });
  }
  greetUserCallback=()=>{
    const state = this.state;
    HelloManager.greetUser(state.userName,state.isAdmin,this.displayResult);
   
  }
  displayResult=(result)=>{
    this.refs.userName.blur();
    this.setState({greetingMessage:result});
    HelloManager.show(result, 0);
  }
  render() {
    return (
      <View>
      <TextInput 
      ref="userName"
      autoCorrect={false}
      placeholder="User Name"
      onChangeText={(text)=> this.setState({userName:text})}
      />
      <Text>Admin</Text>
      <Switch onValueChange={(value)=> this.setState({isAdmin:value})} value={this.state.isAdmin}></Switch>
      
      <Button onPress={this.greetUserCallback}>Greet (callback)</Button>
      <Text>Response:</Text>
      <Text>{this.state.greetingMessage}</Text>
      </View>
    );
  }
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#F5FCFF',
  },
  welcome: {
    fontSize: 20,
    textAlign: 'center',
    margin: 10,
  },
  instructions: {
    textAlign: 'center',
    color: '#333333',
    marginBottom: 5,
  },
});
