package com.modulecustom;

import android.widget.Toast;

import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.HashMap;

public class HelloManager extends ReactContextBaseJavaModule {

    private static final String DURATION_SHORT_KEY = "SHORT";
    private static final String DURATION_LONG_KEY = "LONG";

    public HelloManager(ReactApplicationContext reactContext) {
        super(reactContext);
    }
    @Override
    public String getName() {
        return "HelloManager";
    }

    @ReactMethod
    public void show(String message, int duration) {
        Toast.makeText(getReactApplicationContext(), message, duration).show();
    }

    @ReactMethod
    public void greetUser(String name, Boolean isAdmin,Callback callback) {
        System.out.println("User Name :"+name+", Administrator:" +(isAdmin ? "Yes":"No"));
        String greeting="Welcome "+name+", you " +(isAdmin ? "are":"are not ") +"admin.";
        callback.invoke(greeting);
    }
}