# Welcome to Progress NativeScript UI Pro
[Progress NativeScript UI Pro](http://www.telerik.com/nativescript-ui) a suite of  UI components targeting the NativeScript platform. The controls are based on the familiar [Progress Telerik UI for Android](http://www.telerik.com/android-ui) and [Progress Telerik UI for iOS](http://www.telerik.com/ios-ui) suites and expose common API for utilizing these suites Android and iOS cross-platform development. 

## License

**IMPORTANT** This is not free software. You must obtain one of the licenses listed here: [Progress NativeScript UI](http://www.telerik.com/purchase/nativescript-ui) in order to use it.

If you do not own a commercial license, the use of this product shall be governed by the trial license terms: [Telerik End User License Agreement for UI for NativeScript Pro (Trial version)](http://www.telerik.com/purchase/license-agreement/ui-for-nativescript-pro-trial)

## Components

The suite offers the following components:

### Calendar

- Different view modes: week, month, year
- Appointments support
- Inline events support
- Selection modes: single, multiple, range
- Animated transitions between views
- Styling customizations support

<img src="http://www.telerik.com/sfimages/default-source/blogs/ui-for-nativescript/calendar-nativescript-npm.png?Status=Temp&sfvrsn=2">

### Chart

- 13 chart types
- Numeric, categorical, date-time axes
- Styling customizations
- Interaction: pan & zoom, selection
- Annotations: line, plot
- Trackball

<img src="http://www.telerik.com/sfimages/default-source/blogs/ui-for-nativescript/chart-nativescript-npm.png?Status=Temp&sfvrsn=2">

### DataForm

DataForm for NativeScript allows you to easily build various fill-in forms such as: registration, login, data entry, etc. The controls takes a data object and automatically displays the appropriate editors for the properties of this object, so that the end-user can set the values of these properties with ease. The features at a glance:

- Creates fill-in forms automatically
- Support for custom editors
- Validation rules with feedback messages
- Different commit modes 
- Collapsible groups
- Read-only mode

<img src="http://www.telerik.com/sfimages/default-source/blogs/ui-for-nativescript/dataform-nativescript-npm.png?Status=Temp&sfvrsn=2">

### ListView

ListView for NativeScript is suitable for virtually every mobile application. It’s native underneath which allows for ultimate performance on both iOS and Android. It’s features will enhance your app in many ways. Here they are:

- Multiple templates
- Pull-to-refresh
- Load-on-demand
- Swipe cell to execute
- Header and footer
- Item animations
- Wrap and grid layouts
- Item reorder
- Styling customizations support through code and CSS

<img src="http://www.telerik.com/sfimages/default-source/blogs/ui-for-nativescript/listview-nativescript.png?Status=Temp&sfvrsn=2">

### AutoCompleteTextView
AutoCompleteTextView improves data entry speed and accuracy by triggering auto-completion for text entries. It implements several widely used features like:
- Filtering modes: Contains, StartsWith
- AutoComplete tokens
- Custom suggestions visualization
- Remote data sources

### Gauges

RadGauge for NativeScript is a highly customizable component that allows you to show the current status of a value within a range of upper and lower bounds, illustrate progress towards a goal or a summary of a fluctuating metric.

### SideDrawer

- Different animated transition modes: Fade, Push, Reveal, Reverse Slide Out, Scale Down Pusher, Scale Up, Slide Along, Slide In on Top
- Ability to appear from all four sides of the screen
- Support for custom content

<img src="http://www.telerik.com/sfimages/default-source/blogs/ui-for-nativescript/sidedrawer-nativescript.png?Status=Temp&sfvrsn=2">

## Getting started
For more information on how to use Progress NativeScript UI, please visit the documentation website here [http://docs.telerik.com/devtools/nativescript-ui](http://docs.telerik.com/devtools/nativescript-ui).

You can also take a look at the SDK samples application which is available on GitHub and contains simple scenarios covering all features of the components in Progress NativeScript UI: [http://www.github.com/telerik/nativescript-ui-samples](http://www.github.com/telerik/nativescript-ui-samples).

If you prefer to use Progress NativeScript UI with Angular you can also benefit from our dedicated Angular examples here: [http://www.github.com/telerik/nativescript-ui-samples-angular](http://www.github.com/telerik/nativescript-ui-samples-angular).


## Support

If you do not have a valid license and have downloaded NativeScript UI from nmpjs.org you are not entitled to receive support. If you need technical assistance from the same guys that built the product, you need to get a free Trial from [www.telerik.com](http://www.telerik.com/nativescript-ui) or simply buy a commercial license. This will allow you to post questions on your forums and open private support tickets with a 72h response time.
