Object.defineProperty(exports, "__esModule", { value: true });
var view_1 = require("tns-core-modules/ui/core/view");
var observable_array_1 = require("tns-core-modules/data/observable-array");
var observable_1 = require("tns-core-modules/data/observable");
var weakEvents = require("tns-core-modules/ui/core/weak-event-listener");
var chart_axis_common_1 = require("./visualization/views/chart-axis-common");
var chart_public_enum_1 = require("./misc/chart-public-enum");
var initializersImpl = require("./initializers/chart-initializers");
var RadChartBase = (function (_super) {
    __extends(RadChartBase, _super);
    function RadChartBase() {
        var _this = _super.call(this) || this;
        _this.on("bindingContextChange", _this.baseBindingContextChanged, _this);
        return _this;
    }
    Object.defineProperty(RadChartBase.prototype, "android", {
        get: function () {
            return undefined;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RadChartBase.prototype, "ios", {
        get: function () {
            return undefined;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RadChartBase.prototype, "androidView", {
        get: function () {
            return undefined;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RadChartBase.prototype, "rootLayout", {
        get: function () {
            return undefined;
        },
        enumerable: true,
        configurable: true
    });
    RadChartBase.prototype.reloadPalettes = function () {
        if (this._initializer) {
            this._initializer.reloadPalettes(this);
        }
    };
    Object.defineProperty(RadChartBase.prototype, "initializer", {
        get: function () {
            if (!this._initializer) {
                this._initializer = new initializersImpl.ChartBaseValueMapper();
            }
            return this._initializer;
        },
        enumerable: true,
        configurable: true
    });
    RadChartBase.prototype.updateChart = function () {
    };
    RadChartBase.prototype._addArrayFromBuilder = function (name, value) {
        if (name === "series") {
            this.series = new observable_array_1.ObservableArray(value);
        }
        else if (name === "palettes") {
            this.palettes = new observable_array_1.ObservableArray(value);
        }
        else if (name === "annotations") {
            this.annotations = new observable_array_1.ObservableArray(value);
        }
    };
    RadChartBase.prototype.baseBindingContextChanged = function (data) {
        if (this.series) {
            for (var i = 0; i < this.series.length; i++) {
                this.series.getItem(i).bindingContext = data.value;
                if (this.series.getItem(i).horizontalAxis) {
                    this.series.getItem(i).horizontalAxis.bindingContext = data.value;
                    ;
                }
                if (this.series.getItem(i).verticalAxis) {
                    this.series.getItem(i).verticalAxis.bindingContext = data.value;
                    ;
                }
            }
        }
    };
    RadChartBase.prototype.getAxixByID = function (axisID) {
        return this.getAxisByID(axisID);
    };
    RadChartBase.prototype.getAxisByID = function (axisID) {
        return null;
    };
    RadChartBase.prototype.onLegendPropertyChanged = function (oldValue, newValue) {
        this.onLegendChanged(oldValue, newValue);
    };
    RadChartBase.prototype.onLegendChanged = function (oldValue, newValue) {
        if (this.legend) {
            this.legend.updateLegendView(this);
        }
        this.initializer.onLegendChanged(oldValue, newValue, this);
    };
    RadChartBase.prototype.onPalettesPropertyChanged = function (oldValue, newValue) {
        this.onPalettesChanged(oldValue, newValue);
    };
    RadChartBase.prototype.onPalettesChanged = function (oldValue, newValue) {
        this.initializer.onPalettesPropertyChanged(oldValue, newValue, this);
        if (oldValue instanceof observable_1.Observable) {
            weakEvents.removeWeakEventListener(oldValue, observable_array_1.ObservableArray.changeEvent, this.PalettesCollectionChangedInternal, this);
        }
        if (newValue instanceof observable_1.Observable) {
            weakEvents.addWeakEventListener(newValue, observable_array_1.ObservableArray.changeEvent, this.PalettesCollectionChangedInternal, this);
        }
    };
    RadChartBase.prototype.PalettesCollectionChangedInternal = function (data) {
        this.initializer.onPalettesChanged(data, this);
    };
    RadChartBase.prototype.onSeriesPropertyChanged = function (oldValue, newValue) {
        this.onSeriesChanged(oldValue, newValue);
    };
    RadChartBase.prototype.onSeriesChanged = function (oldValue, newValue) {
        this.initializer.onSeriesPropertyChanged(oldValue, newValue, this);
        if (oldValue instanceof observable_1.Observable) {
            weakEvents.removeWeakEventListener(oldValue, observable_array_1.ObservableArray.changeEvent, this.SeriesCollectionChangedInternal, this);
        }
        if (newValue instanceof observable_1.Observable) {
            weakEvents.addWeakEventListener(newValue, observable_array_1.ObservableArray.changeEvent, this.SeriesCollectionChangedInternal, this);
        }
    };
    RadChartBase.prototype.SeriesCollectionChangedInternal = function (data) {
        this.initializer.onSeriesChanged(data, this);
    };
    RadChartBase.prototype.onAnnotationsPropertyChanged = function (oldValue, newValue) {
        this.onAnnotationsChanged(oldValue, newValue);
    };
    RadChartBase.prototype.onAnnotationsChanged = function (oldValue, newValue) {
        this.initializer.onAnnotationsPropertyChanged(oldValue, newValue, this);
        if (oldValue instanceof observable_1.Observable) {
            weakEvents.removeWeakEventListener(oldValue, observable_array_1.ObservableArray.changeEvent, this.AnnotationsCollectionChangedInternal, this);
        }
        if (newValue instanceof observable_1.Observable) {
            weakEvents.addWeakEventListener(newValue, observable_array_1.ObservableArray.changeEvent, this.AnnotationsCollectionChangedInternal, this);
        }
    };
    RadChartBase.prototype.AnnotationsCollectionChangedInternal = function (data) {
        this.initializer.onAnnotationsChanged(data, this);
    };
    RadChartBase.prototype.onSelectionModePropertyChanged = function (oldValue, newValue) {
        this.onSelectionModeChanged(oldValue, newValue);
    };
    RadChartBase.prototype.onSeriesSelectionModePropertyChanged = function (oldValue, newValue) {
        this.onSeriesSelectionModeChanged(oldValue, newValue);
    };
    RadChartBase.prototype.onPointSelectionModePropertyChanged = function (oldValue, newValue) {
        this.onPointSelectionModeChanged(oldValue, newValue);
    };
    RadChartBase.prototype.onSelectionModeChanged = function (oldValue, newValue) {
    };
    RadChartBase.prototype.onSeriesSelectionModeChanged = function (oldValue, newValue) {
    };
    RadChartBase.prototype.onPointSelectionModeChanged = function (oldValue, newValue) {
    };
    RadChartBase.seriesSelectedEvent = "seriesSelected";
    RadChartBase.seriesDeselectedEvent = "seriesDeselected";
    RadChartBase.pointSelectedEvent = "pointSelected";
    RadChartBase.pointDeselectedEvent = "pointDeselected";
    RadChartBase.chartZoomedEvent = "chartZoomed";
    RadChartBase.chartPannedEvent = "chartPanned";
    RadChartBase.trackballTrackedSelectionEvent = "trackballTrackedSelection";
    RadChartBase.legendProperty = new view_1.Property({
        name: "legend",
        defaultValue: undefined,
        valueChanged: function (target, oldValue, newValue) {
            target.onLegendPropertyChanged(oldValue, newValue);
        },
    });
    RadChartBase.seriesProperty = new view_1.Property({
        name: "series",
        defaultValue: undefined,
        valueChanged: function (target, oldValue, newValue) {
            target.onSeriesPropertyChanged(oldValue, newValue);
        },
    });
    RadChartBase.palettesProperty = new view_1.Property({
        name: "palettes",
        defaultValue: undefined,
        valueChanged: function (target, oldValue, newValue) {
            target.onPalettesPropertyChanged(oldValue, newValue);
        },
    });
    RadChartBase.annotationsProperty = new view_1.Property({
        name: "annotations",
        defaultValue: undefined,
        valueChanged: function (target, oldValue, newValue) {
            target.onAnnotationsPropertyChanged(oldValue, newValue);
        },
    });
    RadChartBase.selectionModeProperty = new view_1.Property({
        name: "selectionMode",
        defaultValue: chart_public_enum_1.ChartSelectionMode.None,
        valueChanged: function (target, oldValue, newValue) {
            target.onSelectionModePropertyChanged(oldValue, newValue);
        },
    });
    RadChartBase.seriesSelectionModeProperty = new view_1.Property({
        name: "seriesSelectionMode",
        defaultValue: chart_public_enum_1.ChartSelectionMode.None,
        valueChanged: function (target, oldValue, newValue) {
            target.onSeriesSelectionModePropertyChanged(oldValue, newValue);
        },
    });
    RadChartBase.pointSelectionModeProperty = new view_1.Property({
        name: "pointSelectionMode",
        defaultValue: chart_public_enum_1.ChartSelectionMode.None,
        valueChanged: function (target, oldValue, newValue) {
            target.onPointSelectionModePropertyChanged(oldValue, newValue);
        },
    });
    __decorate([
        Deprecated,
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", chart_axis_common_1.CartesianAxis)
    ], RadChartBase.prototype, "getAxixByID", null);
    return RadChartBase;
}(view_1.View));
exports.RadChartBase = RadChartBase;
RadChartBase.legendProperty.register(RadChartBase);
RadChartBase.seriesProperty.register(RadChartBase);
RadChartBase.palettesProperty.register(RadChartBase);
RadChartBase.annotationsProperty.register(RadChartBase);
RadChartBase.selectionModeProperty.register(RadChartBase);
RadChartBase.seriesSelectionModeProperty.register(RadChartBase);
RadChartBase.pointSelectionModeProperty.register(RadChartBase);
var RadCartesianChart = (function (_super) {
    __extends(RadCartesianChart, _super);
    function RadCartesianChart() {
        var _this = _super.call(this) || this;
        _this.on("bindingContextChange", _this.bindingContextChanged, _this);
        return _this;
    }
    RadCartesianChart.prototype.onGridPropertyChanged = function (oldValue, newValue) {
        this.onGridChanged(oldValue, newValue);
    };
    RadCartesianChart.prototype.onGridChanged = function (oldValue, newValue) {
    };
    RadCartesianChart.prototype.onHorizontalAxisPropertyChanged = function (oldValue, newValue) {
        this.onHorizontalAxisChanged(oldValue, newValue);
    };
    RadCartesianChart.prototype.onVerticalAxisPropertyChanged = function (oldValue, newValue) {
        this.onVerticalAxisChanged(oldValue, newValue);
    };
    RadCartesianChart.prototype.onHorizontalZoomPropertyChanged = function (oldValue, newValue) {
        this.onHorizontalZoomChanged(oldValue, newValue);
    };
    RadCartesianChart.prototype.onVerticalZoomPropertyChanged = function (oldValue, newValue) {
        this.onVerticalZoomChanged(oldValue, newValue);
    };
    RadCartesianChart.prototype.onTrackballPropertyChanged = function (oldValue, newValue) {
        this.onTrackballChanged(oldValue, newValue);
    };
    RadCartesianChart.prototype.onHorizontalAxisChanged = function (oldValue, newValue) {
        this.updateAxisBindingContext(oldValue, newValue);
    };
    RadCartesianChart.prototype.onVerticalAxisChanged = function (oldValue, newValue) {
        this.updateAxisBindingContext(oldValue, newValue);
    };
    RadCartesianChart.prototype.onHorizontalZoomChanged = function (oldValue, newValue) {
    };
    RadCartesianChart.prototype.onVerticalZoomChanged = function (oldValue, newValue) {
    };
    RadCartesianChart.prototype.onTrackballChanged = function (oldValue, newValue) {
        if (oldValue) {
            oldValue._owner = undefined;
        }
        if (newValue) {
            newValue._owner = this;
        }
    };
    RadCartesianChart.prototype.updateAxisBindingContext = function (oldValue, newValue) {
        if (newValue) {
            newValue.bindingContext = this.bindingContext;
        }
        else {
            if (oldValue) {
                oldValue.bindingContext = null;
            }
        }
    };
    RadCartesianChart.prototype.bindingContextChanged = function (data) {
        if (this.horizontalAxis) {
            this.horizontalAxis.bindingContext = data.value;
            ;
        }
        if (this.verticalAxis) {
            this.verticalAxis.bindingContext = data.value;
            ;
        }
    };
    RadCartesianChart.gridProperty = new view_1.Property({
        name: "grid",
        defaultValue: undefined,
        valueChanged: function (target, oldValue, newValue) {
            target.onGridPropertyChanged(oldValue, newValue);
        },
    });
    RadCartesianChart.horizontalAxisProperty = new view_1.Property({
        name: "horizontalAxis",
        defaultValue: undefined,
        valueChanged: function (target, oldValue, newValue) {
            target.onHorizontalAxisPropertyChanged(oldValue, newValue);
        },
    });
    RadCartesianChart.verticalAxisProperty = new view_1.Property({
        name: "verticalAxis",
        defaultValue: undefined,
        valueChanged: function (target, oldValue, newValue) {
            target.onVerticalAxisPropertyChanged(oldValue, newValue);
        },
    });
    RadCartesianChart.verticalZoomProperty = new view_1.Property({
        name: "verticalZoom",
        defaultValue: undefined,
        valueConverter: parseFloat,
        valueChanged: function (target, oldValue, newValue) {
            target.onVerticalZoomPropertyChanged(oldValue, newValue);
        },
    });
    RadCartesianChart.horizontalZoomProperty = new view_1.Property({
        name: "horizontalZoom",
        defaultValue: undefined,
        valueConverter: parseFloat,
        valueChanged: function (target, oldValue, newValue) {
            target.onHorizontalZoomPropertyChanged(oldValue, newValue);
        },
    });
    RadCartesianChart.trackballProperty = new view_1.Property({
        name: "trackball",
        defaultValue: undefined,
        valueChanged: function (target, oldValue, newValue) {
            target.onTrackballPropertyChanged(oldValue, newValue);
        },
    });
    return RadCartesianChart;
}(RadChartBase));
exports.RadCartesianChart = RadCartesianChart;
RadCartesianChart.gridProperty.register(RadCartesianChart);
RadCartesianChart.horizontalAxisProperty.register(RadCartesianChart);
RadCartesianChart.verticalAxisProperty.register(RadCartesianChart);
RadCartesianChart.verticalZoomProperty.register(RadCartesianChart);
RadCartesianChart.horizontalZoomProperty.register(RadCartesianChart);
RadCartesianChart.trackballProperty.register(RadCartesianChart);
var RadPieChart = (function (_super) {
    __extends(RadPieChart, _super);
    function RadPieChart() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return RadPieChart;
}(RadChartBase));
exports.RadPieChart = RadPieChart;
