Object.defineProperty(exports, "__esModule", { value: true });
var observable_array_1 = require("tns-core-modules/data/observable-array");
var observable_1 = require("tns-core-modules/data/observable");
var weakEvents = require("tns-core-modules/ui/core/weak-event-listener");
var view_1 = require("tns-core-modules/ui/core/view");
var Palette = (function (_super) {
    __extends(Palette, _super);
    function Palette() {
        var _this = _super.call(this) || this;
        _this.entries = new observable_array_1.ObservableArray();
        return _this;
    }
    Palette.prototype._addArrayFromBuilder = function (name, value) {
        if (name === "entries") {
            this.entries = new observable_array_1.ObservableArray(value);
            for (var i = 0; i < this.entries.length; i++) {
                this.entries.getItem(i).ownerPalette = this;
            }
        }
    };
    Palette.prototype.onEntriesPropertyChanged = function (oldValue, newValue) {
        this.onEntriesChanged(oldValue, newValue);
    };
    Palette.prototype.onEntriesChanged = function (oldValue, newValue) {
        if (oldValue instanceof observable_1.Observable) {
            weakEvents.removeWeakEventListener(oldValue, observable_array_1.ObservableArray.changeEvent, this.entriesCollectionChangedInternal, this);
        }
        if (newValue instanceof observable_1.Observable) {
            var collection = newValue;
            if (collection.length >= 0) {
                for (var i = 0; i < collection.length; i++) {
                    this.entries.getItem(i).ownerPalette = this;
                }
                this.updateOwner();
            }
            weakEvents.addWeakEventListener(newValue, observable_array_1.ObservableArray.changeEvent, this.entriesCollectionChangedInternal, this);
        }
    };
    Palette.prototype.entriesCollectionChangedInternal = function (data) {
        if (data.eventName && data.eventName.toLowerCase() === "change") {
            if (data.action && data.action.toLowerCase() === "add") {
                for (var i = 0; i < data.addedCount; i++) {
                    this.entries.getItem(data.index).ownerPalette = this;
                }
            }
        }
        this.updateOwner();
    };
    Palette.prototype.seriesNamePropertyChanged = function (oldValue, newValue) {
        this.onSeriesNamePropertyChanged(oldValue, newValue);
    };
    Palette.prototype.onSeriesNamePropertyChanged = function (oldValue, newValue) {
        this.updateOwner();
    };
    Palette.prototype.seriesStatePropertyChanged = function (oldValue, newValue) {
        this.onSeriesStatePropertyChanged(oldValue, newValue);
    };
    Palette.prototype.onSeriesStatePropertyChanged = function (oldValue, newValue) {
        this.updateOwner();
    };
    Palette.prototype.updateOwner = function () {
        if (this.owner && this.owner.reloadPalettes) {
            this.owner.reloadPalettes();
        }
    };
    Object.defineProperty(Palette.prototype, "owner", {
        get: function () {
            return this._owner;
        },
        set: function (value) {
            this._owner = value;
        },
        enumerable: true,
        configurable: true
    });
    Palette.entriesProperty = new view_1.Property({
        name: "entries",
        defaultValue: undefined,
        valueChanged: function (target, oldValue, newValue) {
            target.onEntriesPropertyChanged(oldValue, newValue);
        },
    });
    Palette.seriesNameProperty = new view_1.Property({
        name: "seriesName",
        defaultValue: undefined,
        valueChanged: function (target, oldValue, newValue) {
            target.seriesNamePropertyChanged(oldValue, newValue);
        },
    });
    Palette.seriesStateProperty = new view_1.Property({
        name: "seriesState",
        defaultValue: undefined,
        valueChanged: function (target, oldValue, newValue) {
            target.seriesStatePropertyChanged(oldValue, newValue);
        },
    });
    return Palette;
}(view_1.ViewBase));
exports.Palette = Palette;
Palette.entriesProperty.register(Palette);
Palette.seriesNameProperty.register(Palette);
Palette.seriesStateProperty.register(Palette);
var PaletteEntry = (function (_super) {
    __extends(PaletteEntry, _super);
    function PaletteEntry() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PaletteEntry.prototype.fillColorPropertyChanged = function (oldValue, newValue) {
        this.onFillColorChanged(oldValue, newValue);
    };
    PaletteEntry.prototype.strokeWidthPropertyChanged = function (oldValue, newValue) {
        this.onStrokeWidthChanged(oldValue, newValue);
    };
    PaletteEntry.prototype.strokeColorPropertyChanged = function (oldValue, newValue) {
        this.onStrokeColorChanged(oldValue, newValue);
    };
    PaletteEntry.prototype.onFillColorChanged = function (oldValue, newValue) {
        this.updateOwner();
    };
    PaletteEntry.prototype.onStrokeWidthChanged = function (oldValue, newValue) {
        this.updateOwner();
    };
    PaletteEntry.prototype.onStrokeColorChanged = function (oldValue, newValue) {
        this.updateOwner();
    };
    PaletteEntry.prototype.updateOwner = function () {
        if (this.ownerPalette && this.ownerPalette.owner && this.ownerPalette.owner.reloadPalettes) {
            this.ownerPalette.owner.reloadPalettes();
        }
    };
    Object.defineProperty(PaletteEntry.prototype, "ownerPalette", {
        get: function () {
            return this._owner;
        },
        set: function (value) {
            this._owner = value;
        },
        enumerable: true,
        configurable: true
    });
    PaletteEntry.fillColorProperty = new view_1.Property({
        name: "fillColor",
        defaultValue: undefined,
        valueChanged: function (target, oldValue, newValue) {
            target.fillColorPropertyChanged(oldValue, newValue);
        },
    });
    PaletteEntry.strokeWidthProperty = new view_1.Property({
        name: "strokeWidth",
        defaultValue: undefined,
        valueConverter: parseFloat,
        valueChanged: function (target, oldValue, newValue) {
            target.strokeWidthPropertyChanged(oldValue, newValue);
        },
    });
    PaletteEntry.strokeColorProperty = new view_1.Property({
        name: "strokeColor",
        defaultValue: undefined,
        valueChanged: function (target, oldValue, newValue) {
            target.strokeColorPropertyChanged(oldValue, newValue);
        },
    });
    return PaletteEntry;
}(view_1.ViewBase));
exports.PaletteEntry = PaletteEntry;
PaletteEntry.fillColorProperty.register(PaletteEntry);
PaletteEntry.strokeWidthProperty.register(PaletteEntry);
PaletteEntry.strokeColorProperty.register(PaletteEntry);
