## node-itk

node-itk是itk的nodejs封装。主要目的是为了用于教学、快速生成和构建基于Web Services的医学图像处理。初衷来自于作者的硕士研究工作Jolly，构建一种适合于图像处理的框架。

## 使用说明

node-itk不需要安装ITK。使用前仅需要require node-itk即可

	require("node-itk")

当前仅支持windows平台。

### NodeImage

封装ITK图像类型，并具有基本的读写功能。

#### 图像像素类型

- char
- unsigned char
- short
- unsigned short
- int
- unsigned int
- long
- unsigned long
- float
- double
- rgb unsigned char

#### 创建图像对象

原型： NodeImage(类型， 维数）

示例： 创建一个的2维灰度图像对象

	var image = NodeImage('uchar', 2)

或者
	
	var image = NodeImage('unsgined char', 2)

#### 填充图像

原型: Fill(灰度值） or Fill(彩色值） 彩色值以Javascript表示
示例： 白色填充

	imgae.Fill(0)

红色填充

	image.Fill([255,0,0])


#### 初始化图像

初始化图像有两种方式

- 通过读取图像

原型： Read(文件路径,  图像类型) 图像类型省略将会根据文件名自动判断

当前支持类型有： 

- tiff
- jpg
- dicom
- png
- bmp

读取一个jpg

	image.Read('x.jpg', 'jpg)

- 通过手工创建

原型： CreateImage(尺寸（以数组或是整数指示每一维）， 像素值（数组代表是彩色））

创建一个10*10*10的红色图像：

	var image = NodeImage('rgb', '3');
	image.CreateImage([10,10,10], [255，0,0]);

#### 写出图像文件

原型 Write(文件名， 图像类型）， 图像类型省略将会根据文件名自动判断

写JPG文件

	image('x.jpg', 'jpg')

#### 读取像素

- GetValue()， 获取像素值，灰度值返回数值，彩色值返回Javascript数组
- GetGreyValue()，获取灰度值，只针对灰度图像
- GetRGBValue()， 获取彩色值，只针对彩色图像

例子见example/pixel.js

#### 写像素

- SetValue(像素值)， 设置像素值，灰度值传数值，彩色值传入Javascript数组
- SetGreyValue(像素值)，设置灰度值，只针对灰度图像
- SetRGBValue(像素值)， 设置彩色值，只针对彩色图像

例子见example/pixel.js

#### 图像类型转换

有时需要对图像类型转换以便于图像处理。node-itk有两种转换

- Cast(图像像素类型) 对图像类型转换
- ScaleCast(图像像素类型) 对图像像素值转换

例子见example/rgb.js

### 阈值分割

#### 二元阈值分割

- 仅设定下阈值
  node_itk.BinaryThresholdBelow(NodeImage, [下阈值, 阈值内替换像素，阈值外替换像素], 处理进度的回调函数， 处理完成后的回调函数）
- 仅设定上阈值
  node_itk.BinaryThresholdAbove(NodeImage, [下阈值, 阈值内替换像素，阈值外替换像素], 处理进度的回调函数， 处理完成后的回调函数）
- 设定上下阈值
   node_itk.BinaryThresholdOutside(NodeImage, [下阈值, 阈值内替换像素，阈值外替换像素], 处理进度的回调函数， 处理完成后的回调函数）

例子见example/BinaryThresholdImage.js

#### 阈值分割（不替换阈值区间内的像素值）

- 仅设定下阈值
  node_itk.ThresholdBelow(NodeImage, [下阈值, 阈值内替换像素，阈值外替换像素], 处理进度的回调函数， 处理完成后的回调函数）
- 仅设定上阈值
  node_itk.ThresholdAbove(NodeImage, [下阈值, 阈值内替换像素，阈值外替换像素], 处理进度的回调函数， 处理完成后的回调函数）
- 设定上下阈值
   node_itk.ThresholdOutside(NodeImage, [下阈值, 阈值内替换像素，阈值外替换像素], 处理进度的回调函数， 处理完成后的回调函数）

算法参数可以采用数组、对象传递，例子见example/BinaryThresholdImage.js

#### Canny边缘检测

参数说明（详见[itkCanny](http://www.itk.org/Doxygen/html/classitk_1_1CannyEdgeDetectionImageFilter.html#a6267bfc6ae3d9f551e47b4246018777b))：

- Variance 和 MaxError 为高斯平滑参数
- UpperThreshold, LowerThreshold是输出图像的阈值


示例
	Number.prototype.toPercent = function(n){n = n || 0;return ( Math.round( this * Math.pow( 10, n + 2 ) ) / Math.pow( 10, n ) ).toFixed( n ) + '%';}

	var node_itk = require('node-itk');

	var image = new node_itk.NodeImage('uchar',2);
	image.Read('uchar', 2, 'Data/BrainProtonDensitySlice.png', 'png');
	var cannyimage = node_itk.CannyEdgeDetection(image, {'Variance':5.0, 'UpperThreshold':0.9, 'LowerThreshold':0},
		function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
		function(err,result){
			if(err=='Success'){
				result.Write('CannyEdgeDetection.bmp', 'bmp')
			}else{
				console.log(err);
			}
		});

## TODO

- 引入图像处理
- 引入矩阵运算
- 引入图像处理组件

## 联系方式
欢迎你对node-itk提出宝贵意见。node-itk还在不断完善

- 作者： 丘文峰(summit chiu)
- Email: summit_mail@qq.com










