## node-itk【内测阶段：每周更新一次, 接口会有变动】

node-itk是itk的nodejs封装。主要目的是为了用于教学、快速生成和构建基于Web Services的医学图像处理。初衷来自于作者的硕士研究工作Jolly，构建一种适合于图像处理的框架。

## 使用说明

node-itk不需要安装ITK。使用前仅需要require node-itk即可

	require("node-itk")

当前仅支持windows平台。

### NodeImage

封装ITK图像类型，并具有基本的读写功能。

#### 图像像素类型

- char
- unsigned char
- short
- unsigned short
- int
- unsigned int
- long
- unsigned long
- float
- double
- rgb unsigned char

#### 创建图像对象

原型： NodeImage(类型， 维数）

示例： 创建一个的2维灰度图像对象

	var image = NodeImage('uchar', 2)

或者
	
	var image = NodeImage('unsgined char', 2)

#### 填充图像

原型: Fill(灰度值） or Fill(彩色值） 彩色值以Javascript表示
示例： 白色填充

	imgae.Fill(0)

红色填充

	image.Fill([255,0,0])


#### 初始化图像

初始化图像有两种方式

- 通过读取图像

原型： Read(文件路径,  图像类型) 图像类型省略将会根据文件名自动判断

当前支持类型有： 

- tiff
- jpg
- dicom
- png
- bmp

读取一个jpg

	image.Read('x.jpg', 'jpg)

- 通过手工创建

原型： CreateImage(尺寸（以数组或是整数指示每一维）， 像素值（数组代表是彩色））

创建一个10*10*10的红色图像：

	var image = NodeImage('rgb', '3');
	image.CreateImage([10,10,10], [255，0,0]);

#### 写出图像文件

原型 Write(文件名， 图像类型）， 图像类型省略将会根据文件名自动判断

写JPG文件

	image('x.jpg', 'jpg')

#### 读取像素

- GetValue()， 获取像素值，灰度值返回数值，彩色值返回Javascript数组
- GetGreyValue()，获取灰度值，只针对灰度图像
- GetRGBValue()， 获取彩色值，只针对彩色图像

例子见example/pixel.js

#### 写像素

- SetValue(像素值)， 设置像素值，灰度值传数值，彩色值传入Javascript数组
- SetGreyValue(像素值)，设置灰度值，只针对灰度图像
- SetRGBValue(像素值)， 设置彩色值，只针对彩色图像

例子见example/pixel.js

#### 图像类型转换

有时需要对图像类型转换以便于图像处理。node-itk有两种转换

- Cast(图像像素类型) 对图像类型转换
- ScaleCast(图像像素类型) 对图像像素值转换

例子见example/rgb.js

### 图像处理

图像处理封装成ImageFilter方法，调用方式如下：

	var cannyimage = node_itk.ImageFilter({
	"InputA": image, // 输入图像，若是二元处理，则参数InputB代表第二张图
	"FilterName":"CannyEdgeDetectionImageFilter", // 图像处理的算法名，与ITK一致，只是去除开头的itk
	"Variance":5.0,  // 输入的参数，与ITK设置函数一致，仅是去除Set，例如这里对应ITK的函数为SetVariance
	"UpperThreshold":0.9, 
	"LowerThreshold":0,
	// 回调函数，用于对图像处理的进度进行处理
	"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))},  
	"Finish": function(r){ 
		/* 图像处理完成后的回调函数，通过一javascript对象返回，
			r.OK=true代表成功，r.ErrorMsg代表出错消息, 
			r.Output代表输出的图像 */
		if(r.OK){
			r.Output.Write('CannyEdgeDetection.bmp', 'bmp')
			console.log(r);
		}else{
			console.log(r);
		}
	}});


#### 二元阈值分割

输入javascript对象说明：

- FilterName: ThresholdImageFilter
- InputA: 输入图像
- LowerThreshold: 阈值下界
- UpperThreshold： 阈值上界
- OutsideValue: 阈值区间外的填充像素值
- InsideValue: 阈值区间内的填充像素值
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/binarythreshold.js]:

	Number.prototype.toPercent = function(n){n = n || 0;return ( Math.round( this * Math.pow( 10, n + 2 ) ) / Math.pow( 10, n ) ).toFixed( n ) + '%';}

	var node_itk = require('node-itk');
	var path = require('path')
	
	var image = new node_itk.NodeImage('uchar',2);
	image.Read('uchar', 2, path.resolve(__dirname, 'Data/BrainProtonDensitySlice.png'), 'png');
	var binaryimage = node_itk.ImageFilter({
		"InputA":image, 
		"FilterName":"BinaryThresholdImageFilter",
		"LowerThreshold":150, 
		"UpperThreshold":180,
		"OutsideValue": 0, 
		"InsideValue": 255,
		"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
		"Finish": function(r){
			if(r.OK){
				r.Output.Write('binaryimage.bmp', 'bmp')
				console.log(r);
			}else{
				console.log(r);
			}
	}});


#### 阈值分割

与二元阈值分割相似，只是缺少InsideValue输入参数。

示例[example/threshold.js]:
	
	var binaryimage = node_itk.ImageFilter({
		"InputA":image, 
		"FilterName":"ThresholdImageFilter",
		"LowerThreshold":170, 
		"UpperThreshold":190,
		"OutsideValue": 0, 
		"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
		"Finish": function(r){
			if(r.OK){
				r.Output.Write('ThresholdImageFilterOutputBelow.bmp', 'bmp')
				console.log(r);
			}else{
				console.log(r);
			}
		}});



#### Canny边缘提取

输入javascript对象说明：

- FilterName: ThresholdImageFilter
- InputA: 输入图像
- Variance 为高斯平滑参数
- MaxError 为高斯平滑参数
- UpperThreshold, 输出图像的阈值上限
- LowerThreshold，输出图像的阈值下限
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效


示例[example/cannyedge.js]:

	var cannyimage = node_itk.ImageFilter({
		"InputA": image, 
		"FilterName":"CannyEdgeDetectionImageFilter", 
		"Variance":5.0, 
		"UpperThreshold":0.9, 
		"LowerThreshold":0,
		"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))},  
		"Finish": function(r){
			if(r.OK){
				r.Output.Write('CannyEdgeDetection.bmp', 'bmp')
				console.log(r);
			}else{
				console.log(r);
			}
	}});

#### 图像归一化

令图像像素均值为0。输入javascript对象说明：

- FilterName: NormalizeImageFilter
- InputA: 输入图像
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/normalize.js]:

	var normalized = node_itk.ImageFilter({
		"InputA":image, 
		"FilterName":"NormalizeImageFilter",
		"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
		"Finish": function(r){
			if(r.OK){
				r.Output.Write('NormalizeImage.bmp', 'bmp')
				console.log(r);
			}else{
				console.log(r);
			}
		}});

#### 图像像素值线性拉伸

- FilterName: NormalizeImageFilter
- InputA: 输入图像
- Shift： 移动的像素值
- Scale： 像素值的缩放比例
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/shiftscale.js]:

	var shiftscale = node_itk.ImageFilter({
		"Input":image, 
		"InputA":image, 
		"FilterName":"ShiftScaleImageFilter",
		"Shift":10, 
		"Scale": 1.0,
		"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
		"Finish": function(r){
			if(r.OK){
				r.Output.Write('ShiftScale.bmp', 'bmp')
				console.log(r)
			}else{
				console.log(r);
			}
	}});

#### 图像非线性拉伸

[itk在线文档](http://www.itk.org/Doxygen/html/classitk_1_1SigmoidImageFilter.html)

- FilterName: SigmoidImageFilter
- InputA: 输入图像
- OutputMinimum： 输出的最小像素值
- OutputMaximum： 输出的最大像素值
- Alpha： 用户提供的拉伸因子
- Beta： 用户提供的拉伸因子
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效
	
示例[example/sigmoid.js]:

	var sigmoid = node_itk.ImageFilter({
	"InputA":image, 
	"FilterName":"SigmoidImageFilter",
	"OutputMinimum":0, 
	"OutputMaximum": 255,
	"Alpha":10.0,
	"Beta":150.0,
	"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
	"Finish": function(r){
		if(r.OK){
			r.Output.Write('sigmoid.bmp', 'bmp')
			console.log(r)
		}else{
			console.log(r);
		}
	}});

### 图像显示-quickview

为了能够便于对比图像处理结果，node-itk包含一个实用显示功能quickview。

	var viewer = new node_itk.NodeQuickView();
	viewer.AddImage({"Input":image,"Flipvertical":true})
	viewer.AddImage({"Input":cannyimage,"Flipvertical":true})
	viewer.Visualize();

通过AddImage可以往显示界面中增加图像。参数说明：

- Input: 要显示的图像
- Flipvertical: 是否翻转图像（可省）
- Description: 图像下方的文本描述（可省）

![quickview](http://www.itk.org/Wiki/images/a/a9/ITK_Examples_Baseline_ImageProcessing_TestSigmoidImageFilter.png)

## TODO

- 引入图像处理
- 引入矩阵运算
- 引入图像处理组件

## 联系方式
欢迎你对node-itk提出宝贵意见。node-itk还在不断完善

- 作者： 丘文峰(summit chiu)
- Email: summit_mail@qq.com










