Number.prototype.toPercent = function(n){n = n || 0;return ( Math.round( this * Math.pow( 10, n + 2 ) ) / Math.pow( 10, n ) ).toFixed( n ) + '%';}

var node_itk = require('node-itk');
var image = new node_itk.NodeImage('float',2);
image.CreateImage([200,300], 0);
for(var i = 200 - 1; i >= 0; i--){
	for (var j = 300 - 1; j >= 0; j--) {
		image.SetGreyPixel(i,j,i-j)
	}
}

var output = node_itk.ImageFilter({
	"InputA":image, 
	"FilterName":"AbsImageFilter",
	"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
	"Finish": function(r){
		if(r.OK){
			r.Output.Write('AbsImageFilter.bmp', 'bmp')
			console.log(r)
		}else{
			console.log(r);
		}
	}});
var viewer = new node_itk.NodeQuickView();
viewer.AddImage({"Input":image,"Flipvertical":true})
viewer.AddImage({"Input":output,"Flipvertical":true})
viewer.Visualize();