Number.prototype.toPercent = function(n){n = n || 0;return ( Math.round( this * Math.pow( 10, n + 2 ) ) / Math.pow( 10, n ) ).toFixed( n ) + '%';}

var node_itk = require('node-itk');
var path = require('path')
var image = new node_itk.NodeImage('char',2);
image.CreateImage([10,10], -100);
var image1 = new node_itk.NodeImage('uchar',2);
image1.CreateImage([10,10], 100);


var output = node_itk.ImageFilter({
	"InputA":image, 
	"InputB":image1,
	"FilterName":"AbsoluteValueDifferenceImageFilter",
	"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
	"Finish": function(r){
		if(r.OK){
			r.Output.Write('AbsoluteValueDifferenceImageFilter.bmp', 'bmp')
			console.log(r.Output.GetPixelType())
			console.log(r.Output.GetGreyPixel(0,0))
			console.log(r)
		}else{
			console.log(r);
		}
	}});

var normalized = node_itk.ImageFilter({
	"InputA":output, 
	"FilterName":"NormalizeImageFilter",
	"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
	"Finish": function(r){
		if(r.OK){
			r.Output.Write('NormalizeImage.bmp', 'bmp')
			console.log(r.Output.GetGreyPixel(0,0))
			console.log(r);
		}else{
			console.log(r);
		}
	}});

var viewer = new node_itk.NodeQuickView();
viewer.AddImage({"Input":image,"Flipvertical":true})
viewer.AddImage({"Input":image1,"Flipvertical":true})
viewer.AddImage({"Input":output,"Flipvertical":true})
viewer.AddImage({"Input":output.Cast('uchar'),"Flipvertical":true})
viewer.Visualize();