## node-itk【内测阶段：每周更新一次, 接口会有变动】

node-itk是itk的nodejs封装。主要目的是为了用于教学、快速生成和构建基于Web Services的医学图像处理。初衷来自于作者的硕士研究工作Jolly，构建一种适合于图像处理的框架。

## 版本说明

- 版本号 0.1.9
	- 增加LabelMap、LabelObject
	- 增加Histogram
	- 增加图像处理：
		- OtsuThresholdImageFilter
		- BinaryContourImageFilter
		- LabelContourImageFilter
		- AggregateLabelMapFilter
		- BinaryImageToStatisticsLabelMapFilter
		- LabelMapToLabelImageFilter
		- BinaryImageToLabelMapFilter
		- GradientAnisotropicDiffusionImageFilter
		- RobustAutomaticThresholdImageFilter
		- AdaptiveHistogramEqualizationImageFilter
		- BinaryFillholeImageFilter
	- Toodo 文档还没有来得及更新，请参考example
- 版本号 0.1.8
	- 增加NodeMatrix和NodeVariableSizeMatrix用作矩阵操作
	- 增加由图像转为NodeVariableSizeMatrix的接口
- 版本号 0.1.7
	- 修复了ScaleCast的Bug
	- 引入二值图像的形态学操作
	- 增加一个能够析取RGB各分量图的操作
	- 增加了三张测试图

## 使用说明

node-itk不需要安装ITK。使用前仅需要require node-itk即可

	require("node-itk")

当前仅支持windows平台。

### NodeImage

封装ITK图像类型，并具有基本的读写功能。

#### 图像像素类型

- char
- unsigned char
- short
- unsigned short
- int
- unsigned int
- long
- unsigned long
- float
- double
- rgb unsigned char

#### 创建图像对象

原型： NodeImage(类型， 维数）

示例： 创建一个的2维灰度图像对象

	var image = NodeImage('uchar', 2)

或者
	
	var image = NodeImage('unsgined char', 2)

#### 填充图像

原型: Fill(灰度值） or Fill(彩色值） 彩色值以Javascript表示
示例： 白色填充

	imgae.Fill(0)

红色填充

	image.Fill([255,0,0])


#### 初始化图像

初始化图像有两种方式

- 通过读取图像

原型： Read(文件路径,  图像类型) 图像类型省略将会根据文件名自动判断

当前支持类型有： 

- tiff
- jpg
- dicom
- png
- bmp

读取一个jpg

	image.Read('x.jpg', 'jpg)

- 通过手工创建

原型： CreateImage(尺寸（以数组或是整数指示每一维）， 像素值（数组代表是彩色））

创建一个10*10*10的红色图像：

	var image = NodeImage('rgb', '3');
	image.CreateImage([10,10,10], [255，0,0]);

#### 写出图像文件

原型 Write(文件名， 图像类型）， 图像类型省略将会根据文件名自动判断

写JPG文件

	image('x.jpg', 'jpg')

#### 读取像素

- GetValue()， 获取像素值，灰度值返回数值，彩色值返回Javascript数组
- GetGreyValue()，获取灰度值，只针对灰度图像
- GetRGBValue()， 获取彩色值，只针对彩色图像

例子见example/pixel.js

#### 写像素

- SetValue(像素值)， 设置像素值，灰度值传数值，彩色值传入Javascript数组
- SetGreyValue(像素值)，设置灰度值，只针对灰度图像
- SetRGBValue(像素值)， 设置彩色值，只针对彩色图像

例子见example/pixel.js

#### 图像类型转换

有时需要对图像类型转换以便于图像处理。node-itk有两种转换

- Cast(图像像素类型) 对图像类型转换
- ScaleCast(图像像素类型) 对图像像素值转换

例子见example/rgb.js

#### 转换成矩阵

- 接口名: ToMatrix
- 参数：无
- 返回类型： VariableSizeMatrix

示例参见[example/nodeVariableSizeMatrix.js]

### 图像处理

图像处理封装成ImageFilter方法，调用方式如下：

	var cannyimage = node_itk.ImageFilter({
	"InputA": image, // 输入图像，若是二元处理，则参数InputB代表第二张图
	"FilterName":"CannyEdgeDetectionImageFilter", // 图像处理的算法名，与ITK一致，只是去除开头的itk
	"Variance":5.0,  // 输入的参数，与ITK设置函数一致，仅是去除Set，例如这里对应ITK的函数为SetVariance
	"UpperThreshold":0.9, 
	"LowerThreshold":0,
	// 回调函数，用于对图像处理的进度进行处理
	"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))},  
	"Finish": function(r){ 
		/* 图像处理完成后的回调函数，通过一javascript对象返回，
			r.OK=true代表成功，r.ErrorMsg代表出错消息, 
			r.Output代表输出的图像 */
		if(r.OK){
			r.Output.Write('CannyEdgeDetection.bmp', 'bmp')
			console.log(r);
		}else{
			console.log(r);
		}
	}});


#### 二元阈值分割

输入javascript对象说明：

- FilterName: ThresholdImageFilter
- InputA: 输入图像
- LowerThreshold: 阈值下界
- UpperThreshold： 阈值上界
- OutsideValue: 阈值区间外的填充像素值
- InsideValue: 阈值区间内的填充像素值
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/binarythreshold.js]:

	Number.prototype.toPercent = function(n){n = n || 0;return ( Math.round( this * Math.pow( 10, n + 2 ) ) / Math.pow( 10, n ) ).toFixed( n ) + '%';}

	var node_itk = require('node-itk');
	var path = require('path')
	
	var image = new node_itk.NodeImage('uchar',2);
	image.Read('uchar', 2, path.resolve(__dirname, 'Data/BrainProtonDensitySlice.png'), 'png');
	var binaryimage = node_itk.ImageFilter({
		"InputA":image, 
		"FilterName":"BinaryThresholdImageFilter",
		"LowerThreshold":150, 
		"UpperThreshold":180,
		"OutsideValue": 0, 
		"InsideValue": 255,
		"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
		"Finish": function(r){
			if(r.OK){
				r.Output.Write('binaryimage.bmp', 'bmp')
				console.log(r);
			}else{
				console.log(r);
			}
	}});


#### 阈值分割

与二元阈值分割相似，只是缺少InsideValue输入参数。

示例[example/threshold.js]:
	
	var binaryimage = node_itk.ImageFilter({
		"InputA":image, 
		"FilterName":"ThresholdImageFilter",
		"LowerThreshold":170, 
		"UpperThreshold":190,
		"OutsideValue": 0, 
		"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
		"Finish": function(r){
			if(r.OK){
				r.Output.Write('ThresholdImageFilterOutputBelow.bmp', 'bmp')
				console.log(r);
			}else{
				console.log(r);
			}
		}});



#### Canny边缘提取

输入javascript对象说明：

- FilterName: ThresholdImageFilter
- InputA: 输入图像
- Variance 为高斯平滑参数
- MaxError 为高斯平滑参数
- UpperThreshold, 输出图像的阈值上限
- LowerThreshold，输出图像的阈值下限
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效


示例[example/cannyedge.js]:

	var cannyimage = node_itk.ImageFilter({
		"InputA": image, 
		"FilterName":"CannyEdgeDetectionImageFilter", 
		"Variance":5.0, 
		"UpperThreshold":0.9, 
		"LowerThreshold":0,
		"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))},  
		"Finish": function(r){
			if(r.OK){
				r.Output.Write('CannyEdgeDetection.bmp', 'bmp')
				console.log(r);
			}else{
				console.log(r);
			}
	}});

#### 图像归一化

令图像像素均值为0。输入javascript对象说明：

- FilterName: NormalizeImageFilter
- InputA: 输入图像
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/normalize.js]:

	var normalized = node_itk.ImageFilter({
		"InputA":image, 
		"FilterName":"NormalizeImageFilter",
		"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
		"Finish": function(r){
			if(r.OK){
				r.Output.Write('NormalizeImage.bmp', 'bmp')
				console.log(r);
			}else{
				console.log(r);
			}
		}});

#### 图像像素值线性拉伸

- FilterName: NormalizeImageFilter
- InputA: 输入图像
- Shift： 移动的像素值
- Scale： 像素值的缩放比例
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/shiftscale.js]:

	var shiftscale = node_itk.ImageFilter({
		"Input":image, 
		"InputA":image, 
		"FilterName":"ShiftScaleImageFilter",
		"Shift":10, 
		"Scale": 1.0,
		"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
		"Finish": function(r){
			if(r.OK){
				r.Output.Write('ShiftScale.bmp', 'bmp')
				console.log(r)
			}else{
				console.log(r);
			}
	}});

#### 图像非线性拉伸

[itk在线文档](http://www.itk.org/Doxygen/html/classitk_1_1SigmoidImageFilter.html)

- FilterName: SigmoidImageFilter
- InputA: 输入图像
- OutputMinimum： 输出的最小像素值
- OutputMaximum： 输出的最大像素值
- Alpha： 用户提供的拉伸因子
- Beta： 用户提供的拉伸因子
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效
	
示例[example/sigmoid.js]:

	var sigmoid = node_itk.ImageFilter({
	"InputA":image, 
	"FilterName":"SigmoidImageFilter",
	"OutputMinimum":0, 
	"OutputMaximum": 255,
	"Alpha":10.0,
	"Beta":150.0,
	"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
	"Finish": function(r){
		if(r.OK){
			r.Output.Write('sigmoid.bmp', 'bmp')
			console.log(r)
		}else{
			console.log(r);
		}
	}});

### 图像运算：绝对值

- FilterName: AbsImageFilter
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/nodeAbsImageFilter.js]:

	Number.prototype.toPercent = function(n){n = n || 0;return ( Math.round( this * Math.pow( 10, n + 2 ) ) / Math.pow( 10, n ) ).toFixed( n ) + '%';}

	var node_itk = require('./node-itk');
	var image = new node_itk.NodeImage('float',2);
	image.CreateImage([200,300], 0);
	for(var i = 200 - 1; i >= 0; i--){
		for (var j = 300 - 1; j >= 0; j--) {
			image.SetGreyPixel(i,j,i-j)
		}
	}
	
	var output = node_itk.ImageFilter({
		"InputA":image, 
		"FilterName":"AbsImageFilter",
		"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
		"Finish": function(r){
			if(r.OK){
				r.Output.Write('AbsImageFilter.bmp', 'bmp')
				console.log(r)
			}else{
				console.log(r);
			}
		}});
	var viewer = new node_itk.NodeQuickView();
	viewer.AddImage({"Input":image,"Flipvertical":true})
	viewer.AddImage({"Input":output,"Flipvertical":true})
	viewer.Visualize();

### 图像运算：反余弦

- FilterName: AcosImageFilter
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/nodeAbsImageFilter.js]:

	Number.prototype.toPercent = function(n){n = n || 0;return ( Math.round( this * Math.pow( 10, n + 2 ) ) / Math.pow( 10, n ) ).toFixed( n ) + '%';}
	
	var node_itk = require('./node-itk');
	var image = new node_itk.NodeImage('float',2);
	image.CreateImage([10,10], 0);
	var k=0;
	for(var i = 0; i <10; i++){
		for (var j = 0; j <10; j++) {
			image.SetGreyPixel(i,j,k++/99.0)
		}
	}
	var output = node_itk.ImageFilter({
		"InputA":image, 
		"FilterName":"AcosImageFilter",
		"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
		"Finish": function(r){
			if(r.OK){
				r.Output.Write('AcosImageFilter.bmp', 'bmp')
				console.log(r)
			}else{
				console.log(r);
			}
		}});
	var res = new Array(10);
	for (var i = 0; i < 10; i++) {
	    res[i] = new Array(10);
	  }
	for(var i = 0; i <10; i++){
		for (var j = 0; j <10; j++) {
			res[i][j] = image.GetGreyPixel(i,j)
		}
	}
	console.log(res);
	for(var i = 0; i <10; i++){
		for (var j = 0; j <10; j++) {
			res[i][j] = output.GetGreyPixel(i,j)
		}
	}
	console.log(res);

### 图像运算：绝对差值

- InputA: 输入图像1
- InputB: 输入图像2
- FilterName: AbsoluteValueDifferenceImageFilter
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：

	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

注明：结果为|InputA-InputB|

示例[example/nodeAbsoluteValueDifferenceImageFilter.js]

### 图像运算：像素值累加（沿指定维，降维操作）

- InputA: 输入图像
- FilterName: AccumulateImageFilter
- AccumulateDimension： 维标（取值为1,2,3...n)
- Average: 是否对累加值求均（默认false)
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/nodeAccumulateImageFilter.js]

### 图像运算：像素值均值（沿指定维，降维操作）

- InputA: 输入图像
- FilterName: GetAverageSliceImageFilter
- AveragedOutDimension： 维标（取值为1,2,3...n)
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/nodeGetAverageSliceImageFilter.js]

### 图像运算：求导（沿指定维）

- InputA: 输入图像
- FilterName: DerivativeImageFilter
- Direction： 取值为0，1，2....
- Order: 阶数（取值为1，2，3...）
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效


示例[example/nodeDerivativeImageFilter.js]

### 图像运算：梯度算子

- InputA: 输入图像
- FilterName: GradientMagnitudeImageFilter
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/nodeGradientMagnitudeImageFilter.js]


### 图像运算：带高斯平滑的梯度算子

- InputA: 输入图像
- FilterName: GradientMagnitudeRecursiveGaussianImageFilter
- Sigma: 高斯平滑因子
- NormalizeAcrossScale：是否规范化
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/nodeGradientMagnitudeRecursiveGaussianImageFilter.js]

### 图像平滑：均值滤波

- InputA: 输入图像
- FilterName: MeanImageFilter
- Radius: Javascript数组，代表每一维的半径长
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/nodeMeanImageFilter.js]

### 形态学结构元素说明

包含三类结构元素：

- 二值球状（BINARY_BALL）
- 二值十字线（BINARY_CROSS）
- 平直结构元素（Flat)
	- 环状（Annulus）
	- 球状（Ball )
	- 盒状( Box )
	- 十字线（Cross）
	- 多边形状（Polygon）

默认为二值球状。结果元素半径通过Radius属性设置

### 二值形态学操作：腐蚀

具体说明参见[itkBinaryErodeImageFilter](http://www.itk.org/Doxygen44/html/classitk_1_1BinaryErodeImageFilter.html)

- InputA: 输入图像
- FilterName: BinaryErodeImageFilter
- BoundaryToForeground：默认为false，可省
- ForegroundValue：前景值，可省
- BackgroundValue: 背景值，可省
- Radius：结构元素半径，Javascript数组
- ElementType：结构元素类型【BINARY_BALL || BINARY_CROSS ||  Flat】
- Shape: 若ElementType为Flat时有效，为一javascript对象，Type指明形状【Annulus || Ball || Box or Cross || Polygon】
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例：[example/nodeBinaryErodeImageFilter.js]

### 二值形态学操作：膨胀


- InputA: 输入图像
- FilterName: BinaryDilateImageFilter
- BoundaryToForeground：默认为false，可省
- ForegroundValue：前景值，可省
- BackgroundValue: 背景值，可省
- Radius：结构元素半径，Javascript数组
- ElementType：结构元素类型【BINARY_BALL || BINARY_CROSS ||  Flat】
- Shape: 若ElementType为Flat时有效，为一javascript对象，Type指明形状【Annulus || Ball || Box or Cross || Polygon】
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例：[example/nodeDilateImageFilter.js]

### 二值形态学操作：闭操作

- InputA: 输入图像
- FilterName: BinaryMorphologicalClosingImageFilter
- Radius：结构元素半径，Javascript数组
- ElementType：结构元素类型【BINARY_BALL || BINARY_CROSS ||  Flat】
- Shape: 若ElementType为Flat时有效，为一javascript对象，Type指明形状【Annulus || Ball || Box or Cross || Polygon】
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例：[example/nodeBinaryMorphologicalClosingImageFilter.js]


### 二值形态学操作：开操作

- InputA: 输入图像
- FilterName: BinaryMorphologicalOpeningImageFilter
- Radius：结构元素半径，Javascript数组
- ElementType：结构元素类型【BINARY_BALL || BINARY_CROSS ||  Flat】
- Shape: 若ElementType为Flat时有效，为一javascript对象，Type指明形状【Annulus || Ball || Box or Cross || Polygon】
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例：[example/nodeBinaryMorphologicalOpeningImageFilter.js]

### 二值形态学操作：针对图像对象的腐蚀操作

- InputA: 输入图像
- FilterName: ErodeObjectMorphologyImageFilter
- Radius：结构元素半径，Javascript数组
- ElementType：结构元素类型【BINARY_BALL || BINARY_CROSS ||  Flat】
- Shape: 若ElementType为Flat时有效，为一javascript对象，Type指明形状【Annulus || Ball || Box or Cross || Polygon】
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效


### 二值形态学操作：针对图像对象的膨胀操作

- InputA: 输入图像
- FilterName: DilateObjectMorphologyImageFilter
- Radius：结构元素半径，Javascript数组
- ElementType：结构元素类型【BINARY_BALL || BINARY_CROSS ||  Flat】
- Shape: 若ElementType为Flat时有效，为一javascript对象，Type指明形状【Annulus || Ball || Box or Cross || Polygon】
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

### 二值形态学操作：图像细化（骨架化）

- InputA: 输入图像
- FilterName: BinaryThinningImageFilter
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例

	Number.prototype.toPercent = function(n){n = n || 0;return ( Math.round( this * Math.pow( 10, n + 2 ) ) / Math.pow( 10, n ) ).toFixed( n ) + '%';}
	
	var node_itk = require('node-itk');
	var path = require('path')
	var image = new node_itk.NodeImage('uchar',2);
	var image = new node_itk.NodeImage('uchar',2);
	image.CreateImage([100,100], 0);
	for(var i = 20; i<80; i++){
		for (var j = 50; j <55 ; j++) {
			image.SetGreyPixel(i,j,255)
		}
	}
	var output = node_itk.ImageFilter({
		"InputA":image, 
		"FilterName":"BinaryThinningImageFilter",
		"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
		"Finish": function(r){
			if(r.OK){
				r.Output.Write('BinaryThinningImageFilter.bmp', 'bmp')
				console.log(r)
			}else{
				console.log(r);
			}
		}});
	output = output.ScaleCast('uchar');
	var viewer = new node_itk.NodeQuickView();
	viewer.AddImage({"Input":image,"Flipvertical":true})
	viewer.AddImage({"Input":output,"Flipvertical":true})
	viewer.Visualize();

### 二值形态学操作：图像修剪

- InputA: 输入图像
- FilterName: BinaryPruningImageFilter
- Iteration： 迭代次数
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例[example/nodeBinaryPruningImageFilter.js]


### 二值形态学操作：带连通的闭操作

- InputA: 输入图像
- FilterName: BinaryClosingByReconstructionImageFilter
- Radius：结构元素半径，Javascript数组
- ElementType：结构元素类型【BINARY_BALL || BINARY_CROSS ||  Flat】
- Shape: 若ElementType为Flat时有效，为一javascript对象，Type指明形状【Annulus || Ball || Box or Cross || Polygon】
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

### 二值形态学操作：带连通的开操作

- InputA: 输入图像
- FilterName: BinaryOpeningByReconstructionImageFilter
- Radius：结构元素半径，Javascript数组
- ElementType：结构元素类型【BINARY_BALL || BINARY_CROSS ||  Flat】
- Shape: 若ElementType为Flat时有效，为一javascript对象，Type指明形状【Annulus || Ball || Box or Cross || Polygon】
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

### 析取RGB各分量

- InputA: 输入图像
- FilterName: ExtractRGBChannelFilter
- Channel: 取值为[ R || G || B ]
- Progress: 回调函数，用于对图像进度进行控制（多用于交互的进度显示）
- Finish: 回调函数,用于对图像处理完成的响应，返回javascript对象说明：
	- OK : true代表图像处理成功, false代表图像处理失败
	- ErrorMsg: 当OK=false时，包含出错的文本消息
	- Output: 输出的结果，仅当OK=true时有效

示例参见[example/nodeExtractRGBChannelFilter.js]

### 图像显示-quickview

为了能够便于对比图像处理结果，node-itk包含一个实用显示功能quickview。

示例[example/cannyedge.js]

	var viewer = new node_itk.NodeQuickView();
	viewer.AddImage({"Input":image,"Flipvertical":true})
	viewer.AddImage({"Input":cannyimage,"Flipvertical":true})
	viewer.Visualize();

通过AddImage可以往显示界面中增加图像。参数说明：

- Input: 要显示的图像
- Flipvertical: 是否翻转图像（可省）
- Description: 图像下方的文本描述（可省）

![quickview](http://www.itk.org/Wiki/images/a/a9/ITK_Examples_Baseline_ImageProcessing_TestSigmoidImageFilter.png)

## 矩阵操作

node-itk包含两类**2维**矩阵

- NodeMatrix
- NodeVariableSizeMatrix


### NodeMatrix

Matrix的大小是确定的矩阵，当前仅有2x2, 3x3, 4x4方阵。仅用作图像处理辅助，一般不使用。

### NodeVariableSizeMatrix

维数可变的2维矩阵。

#### 创建矩阵

传入矩阵的行，列数，若缺少列数代表创建方阵，示例如下（创建一个2x2矩阵）：

	m2 = new node_itk.NodeVariableSizeMatrix(2);


#### 获取矩阵行数

- 接口名：Rows
- 参数： 无
- 返回类型：整型

#### 获取矩阵列数

- 接口名：Cols
- 参数： 无
- 返回类型：整型

#### 填充矩阵

- 接口名：Fill
- 参数： 数值
- 返回类型：填充后的矩阵

#### 设置为单位矩阵

- 接口名：SetIdentity
- 参数：无
- 返回类型： 设置后的矩阵


#### 矩阵转置

- 接口名：GetTranspose
- 参数：无
- 返回类型： 转置后的矩阵

#### 矩阵是否不相等

- 接口名：NEQ
- 参数：要比较的矩阵
- 返回类型： 布尔类型

#### 矩阵是否相等

- 接口名：EQ
- 参数：要比较的矩阵
- 返回类型： 布尔类型

#### 获取矩阵的元素

- 接口名：GetElement
- 参数：行号，列号
- 返回类型： 数值

#### 设置矩阵的元素值

- 接口名：SetElement
- 参数：行号，列号，元素值
- 返回类型： 数值

#### 矩阵相加

- 接口名：Add
- 参数：JS数组或矩阵
- 返回类型： 相加后的矩阵

#### 矩阵相减

- 接口名：Sub
- 参数：JS数组或矩阵
- 返回类型： 相减后的矩阵

#### 矩阵除

- 接口名：Div
- 参数：数值
- 返回类型： 相除后的矩阵

#### 矩阵乘

- 接口名：Div
- 参数：数值，一维数组、两维数组和矩阵
- 返回类型： 相乘后的矩阵

#### 矩阵赋值

- 接口名：Assign
- 参数：两维数组和矩阵
- 返回类型： 赋值后的矩阵

#### 获取矩阵一行元素

- 接口名：GetRow
- 参数：行号
- 返回类型： 一维JS数组

#### 打印矩阵

- 接口名：ToString
- 参数：无
- 返回类型： 可打印的字符串

#### 转换为JS数组

- 接口名：ToArray
- 参数：无
- 返回类型： 两维JS数组

#### 矩阵求逆

- 接口名：GetInverse
- 参数：无
- 返回类型： 逆矩阵

#### 转为图像

- 接口名：ToImage
- 参数：字符串表示像素类型，默认为double
- 返回类型：图像

示例参见[example/nodeVariableSizeMatrix.js]

## TODO

- 引入图像变换

## 安装相关问题

若提示不是有效的windows应用程序时，请在bin文件夹安装相关的vcredist（x64 or x86）

## 联系方式
欢迎你对node-itk提出宝贵意见。node-itk还在不断完善

- 作者： 丘文峰(summit chiu)
- Email: summit_mail@qq.com











