Number.prototype.toPercent = function(n){n = n || 0;return ( Math.round( this * Math.pow( 10, n + 2 ) ) / Math.pow( 10, n ) ).toFixed( n ) + '%';}


var node_itk = require('node-itk');
var image = new node_itk.NodeImage('uchar',2);
image.CreateImage([20,20], 0);
for(var i = 5; i < 10; i++){
	for (var j = 5; j < 10; j++) {
		image.SetGreyPixel(i,j,255)
	}
}
var output = node_itk.ImageFilter({
	"InputA":image, 
	"FilterName":"BinaryContourImageFilter",
	"ForegroundValue": 0,
	"BackgroundValue": 255,
	"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
	"Finish": function(r){
		if(r.OK){
			r.Output.Write('BinaryContourImageFilter.bmp', 'bmp')
			console.log(r)
		}else{
			console.log(r);
		}
	}});
var viewer = new node_itk.NodeQuickView();
viewer.AddImage({"Input":image,"Flipvertical":true})
viewer.AddImage({"Input":output,"Flipvertical":true})
viewer.Visualize();