Number.prototype.toPercent = function(n){n = n || 0;return ( Math.round( this * Math.pow( 10, n + 2 ) ) / Math.pow( 10, n ) ).toFixed( n ) + '%';}

var node_itk = require('node-itk');
var path = require('path')
var image = new node_itk.NodeImage('uchar',2);
image.Read('rgb', 2, path.resolve(__dirname, 'Data/GourdsRGB.png'), 'png');
var outputR = node_itk.ImageFilter({
	"InputA":image, 
	"FilterName":"ExtractRGBChannelFilter",
	"Channel":"R",
	"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
	"Finish": function(r){
		if(r.OK){
			r.Output.Write('ExtractRGBChannelFilterR.bmp', 'bmp')
			console.log(r)
		}else{
			console.log(r);
		}
	}});
var outputG = node_itk.ImageFilter({
	"InputA":image, 
	"FilterName":"ExtractRGBChannelFilter",
	"Channel":"G",
	"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
	"Finish": function(r){
		if(r.OK){
			r.Output.Write('ExtractRGBChannelFilterG.bmp', 'bmp')
			console.log(r)
		}else{
			console.log(r);
		}
	}});
var outputB = node_itk.ImageFilter({
	"InputA":image, 
	"FilterName":"ExtractRGBChannelFilter",
	"Channel":"B",
	"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
	"Finish": function(r){
		if(r.OK){
			r.Output.Write('ExtractRGBChannelFilterB.bmp', 'bmp')
			console.log(r)
		}else{
			console.log(r);
		}
	}});
var viewer = new node_itk.NodeQuickView();
viewer.AddImage({"Input":image,"Flipvertical":true})
viewer.AddImage({"Input":outputR,"Flipvertical":true})
viewer.AddImage({"Input":outputG,"Flipvertical":true})
viewer.AddImage({"Input":outputB,"Flipvertical":true})
viewer.Visualize();