Number.prototype.toPercent = function(n){n = n || 0;return ( Math.round( this * Math.pow( 10, n + 2 ) ) / Math.pow( 10, n ) ).toFixed( n ) + '%';}

var node_itk = require('node-itk');
var path = require('path')
var image = new node_itk.NodeImage('uchar',2);
image.Read('uchar', 2, path.resolve(__dirname, 'Data/BrainProtonDensitySlice.png'), 'png');
var output = node_itk.ImageFilter({
	"InputA":image, 
	"FilterName":"OtsuThresholdImageFilter",
	"Progress": function(progress){console.log('处理进度:'+progress.toPercent(2))}, 
	"Finish": function(r){
		if(r.OK){
			r.Output.Write('OtsuThresholdImageFilter.bmp', 'bmp')
			console.log(r)
		}else{
			console.log(r);
		}
	}});
var viewer = new node_itk.NodeQuickView();
viewer.AddImage({"Input":image,"Flipvertical":true})
viewer.AddImage({"Input":output,"Flipvertical":true})
viewer.Visualize();