#include "global.h"

///////////////////////////////////////////////////////////////////////////
std::string parameterType::value() const
{
    assert(m_type == Scalar);
    assert(m_values.size() == 1);

	return m_values.front();
}

///////////////////////////////////////////////////////////////////////////
std::list<std::string> parameterType::values() const
{
    assert(m_type == Array);

    return m_values;
}

///////////////////////////////////////////////////////////////////////////
std::string parameterType::to_string() const
{
	std::string s("\"" + m_name + "\": ");

	switch (m_type)
	{
		case Scalar:
			s += "\"" + m_values.front() + "\"";
			break;
		case Array:
			s += ::to_string(m_values);
			break;
		case Null:
			s += "null";
		default:
			break;
	}

	return s;
}

///////////////////////////////////////////////////////////////////////////
bool isDebug()
{
    char* env = getenv("DEBUG");
    if (!env)
    {
        return false;
    }

    return (_stricmp(env, "*") == 0 || _stricmp(env, "oracleBindings") == 0);
}

///////////////////////////////////////////////////////////////////////////
void replace(std::string& str, const std::string& from, const std::string& to)
{
    for (;;)
    {
		size_t start_pos = str.find(from);
		if (start_pos == std::string::npos)
		{
			return;
		}
		str.replace(start_pos, from.length(), to);
	}
}

///////////////////////////////////////////////////////////////////////////
void hexDump(const char* desc, const void* addr, int len)
{
    int i;
    unsigned char buff[17];
    const unsigned char* pc = reinterpret_cast<const unsigned char*>(addr);

    // Output description if given.
    if (desc != NULL)
        printf ("%s:\n", desc);

    // Process every byte in the data.
    for (i = 0; i < len; i++) {
        // Multiple of 16 means new line (with line offset).
        if ((i % 16) == 0) {
            // Just don't print ASCII for the zeroth line.
            if (i != 0)
                printf ("  %s\n", buff);

            // Output the offset.
            printf ("  %04x ", i);
        }

        // Now the hex code for the specific character.
        printf (" %02x", pc[i]);

        // And store a printable ASCII character for later.
        if ((pc[i] < 0x20) || (pc[i] > 0x7e))
            buff[i % 16] = '.';
        else
            buff[i % 16] = pc[i];
        buff[(i % 16) + 1] = '\0';
    }

    // Pad out last line if not exactly 16 characters.
    while ((i % 16) != 0) {
        printf ("   ");
        i++;
    }

    // And print the final ASCII bit.
    printf ("  %s\n", buff);
}

///////////////////////////////////////////////////////////////////////////
void convert(const propertyListType& properties, stringListType* names, stringListType* values)
{
	assert(names && values);

	names->clear();
	values->clear();

	propertyListConstIteratorType it;
	for (it = properties.begin(); it != properties.end(); ++it)
	{
		names->push_back(it->name);
		values->push_back(it->value);
	}

	assert(properties.size() == names->size());
	assert(properties.size() == values->size());
}

///////////////////////////////////////////////////////////////////////////
std::string to_string(const std::list<std::string>& list)
{
	std::list<std::string>::const_iterator it;
	std::string s;

	s = "[";
	for (it = list.begin(); it != list.end(); ++it)
	{
		if (it != list.begin())
		{
			s += ",";
		}
		s += "\"" + *it + "\"";
	}
	s += "]";

	return s;
}

///////////////////////////////////////////////////////////////////////////
std::string to_string(const propertyListType& list)
{
	propertyListConstIteratorType it;
	std::string s;

	s = "{\n";
	for (it = list.begin(); it != list.end(); ++it)
	{
		if (it != list.begin())
		{
			s += ",";
		}
		s += "\"" + it->name + "\": \"" + it->value +"\"\n";
	}
	s += "}";

	return s;
}

///////////////////////////////////////////////////////////////////////////
std::string to_string(const parameterListType& list)
{
	parameterListConstIteratorType it;
	std::string s;

	s = "{\n";
	for (it = list.begin(); it != list.end(); ++it)
	{
		if (it != list.begin())
		{
			s += ",";
		}
		s += it->to_string() + "\n";
	}
	s += "}";

	return s;
}
