/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.commands;

import java.util.LinkedList;
import net.sf.jasperreports.web.commands.Command;
import net.sf.jasperreports.web.commands.CommandException;

public class CommandStack {
    private LinkedList<Command> commandStack = new LinkedList();
    private LinkedList<Command> redoStack = new LinkedList();

    public void execute(Command command) throws CommandException {
        try {
            command.execute();
        }
        catch (CommandException e) {
            command.undo();
            throw e;
        }
        this.commandStack.addFirst(command);
        this.redoStack.clear();
    }

    public void undo() {
        if (this.commandStack.isEmpty()) {
            return;
        }
        Command command = this.commandStack.removeFirst();
        command.undo();
        this.redoStack.addFirst(command);
    }

    public void redo() {
        if (this.redoStack.isEmpty()) {
            return;
        }
        Command command = this.redoStack.removeFirst();
        command.redo();
        this.commandStack.addFirst(command);
    }

    public void undoAll() {
        if (this.commandStack.isEmpty()) {
            return;
        }
        while (!this.commandStack.isEmpty()) {
            this.undo();
        }
    }

    public void redoAll() {
        if (this.redoStack.isEmpty()) {
            return;
        }
        while (!this.redoStack.isEmpty()) {
            this.redo();
        }
    }

    public void clear() {
        this.commandStack.clear();
        this.redoStack.clear();
    }

    public int getExecutionStackSize() {
        return this.commandStack.size();
    }
}

