/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/

const work_dir=process.cwd();
var express=require('express');
var morgan=require('morgan');
var compression=require('compression');
var bodyParser=require('body-parser');
var sass=require('node-sass-middleware');
var fs=require('fs');
var session = require('express-session');
var RDBStore = require('./rethinkdb-session')(session);
var passport = require('passport');
const route_dir="/app/routes";


module.exports=function(db,config,validator,jvm){
    var app = express();
    //console.log(validate_model);

    console.log("nylon Server run at env : "+process.env.NODE_ENV);

    var rdbStore = new RDBStore({
            connection: db,
            db: 'oauth',
            table: 'session',
            sessionTimeout: 86400000,
            flushInterval: 60000,
            debug: false
    });


    app.use(session({
            resave: false,
            saveUninitialized: true,
            key: 'sid',
            secret: 'my5uperSEC537(key)!',
            cookie: { maxAge: 860000 },
            store: rdbStore
    }));

    app.use(passport.initialize());
    app.use(passport.session());

    if (process.env.NODE_ENV === 'development') {
        app.use(morgan('dev'));
    }else{
         app.use(compression());
    }



    app.use(bodyParser.urlencoded({ extended: true }));
    app.use(bodyParser.json());
    app.use(function(req,res,next){
         console.log("client request pid "+process.pid);
         req._r=db;
         req._config=config;
         req._validator=validator;
         req._jvm=jvm;

       
         next();
    });

    require('./iReport')(app);
    require('./oauth/oauth.routes')(app);



    app.set('views',work_dir+'/app/views');
    app.set('view engine','jade');

    //config routes
    var routes = fs.readdirSync(work_dir+route_dir);
    for (var i in routes){
        if(routes[i].endsWith(".routes.js")){
            var r = route_dir + '/' + routes[i];
            //console.log(r);
            require(work_dir+r)(app);
            console.log("nylon start route :: "+r);
        }
    }

    

    app.use(sass({
        src:work_dir+'/sass',
        dest:work_dir+'/public/css',
        outputStyle:'compressed',
        prefix:'/css'
    }));

    //config static
    app.use(express.static(work_dir+'/public'));
    return app;
}