/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.components.headertoolbar.actions.AbstractVerifiableTableAction;
import net.sf.jasperreports.components.headertoolbar.actions.ConditionalFormattingCommand;
import net.sf.jasperreports.components.headertoolbar.actions.ConditionalFormattingData;
import net.sf.jasperreports.components.headertoolbar.actions.FormatCondition;
import net.sf.jasperreports.components.headertoolbar.json.ColumnFormatting;
import net.sf.jasperreports.components.sort.FilterTypeDateOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.ResetInCacheCommand;

public class ConditionalFormattingAction
extends AbstractVerifiableTableAction {
    public ConditionalFormattingData getConditionalFormattingData() {
        return (ConditionalFormattingData)this.columnData;
    }

    public void setConditionalFormattingData(ConditionalFormattingData conditionalFormattingData) {
        this.columnData = conditionalFormattingData;
    }

    @Override
    public void performAction() throws ActionException {
        try {
            this.fillColumnFormatting();
            this.getCommandStack().execute(new ResetInCacheCommand(new ConditionalFormattingCommand(this.getJasperReportsContext(), this.getTargetTextField(), this.getConditionalFormattingData()), this.getJasperReportsContext(), this.getReportContext(), this.targetUri));
        }
        catch (CommandException e) {
            throw new ActionException(e);
        }
    }

    protected void fillColumnFormatting() {
        ConditionalFormattingData conditionalFormattingData = (ConditionalFormattingData)this.columnData;
        ColumnFormatting columnFormatting = ColumnFormatting.get(this.getReportContext(), conditionalFormattingData.getTableUuid(), conditionalFormattingData.getColumnIndex());
        if (columnFormatting != null) {
            if (conditionalFormattingData.getLocaleCode() == null) {
                conditionalFormattingData.setLocaleCode(columnFormatting.getLocaleCode());
            }
            if (conditionalFormattingData.getTimeZoneId() == null) {
                conditionalFormattingData.setTimeZoneId(columnFormatting.getTimeZoneId());
            }
        }
    }

    private JRTextField getTargetTextField() {
        ConditionalFormattingData cfData = this.getConditionalFormattingData();
        List<BaseColumn> allCols = TableUtil.getAllColumns(this.table);
        StandardColumn col = (StandardColumn)allCols.get(cfData.getColumnIndex());
        JRTextField result = null;
        if ("detailrows".equals(cfData.getApplyTo())) {
            result = TableUtil.getCellElement(JRTextField.class, col.getDetailCell(), true);
        } else if ("groupsubtotal".equals(cfData.getApplyTo())) {
            result = TableUtil.getCellElement(JRTextField.class, col, 6, cfData.getGroupName(), this.table);
        } else if ("groupheading".equals(cfData.getApplyTo())) {
            result = TableUtil.getCellElement(JRTextField.class, col, 5, cfData.getGroupName(), this.table);
        } else if ("tabletotal".equals(cfData.getApplyTo())) {
            result = TableUtil.getCellElement(JRTextField.class, col, 1, null, this.table);
        }
        return result;
    }

    @Override
    public void verify() throws ActionException {
        ConditionalFormattingData cfd = this.getConditionalFormattingData();
        List<FormatCondition> conditions = cfd.getConditions();
        if (conditions.size() > 0) {
            FilterTypesEnum conditionType = FilterTypesEnum.getByName(cfd.getConditionType());
            Locale locale = (Locale)this.getReportContext().getParameterValue("REPORT_LOCALE");
            if (locale == null) {
                locale = Locale.getDefault();
            }
            int ln = conditions.size();
            for (int i = 0; i < ln; ++i) {
                FormatCondition condition = conditions.get(i);
                if (FilterTypesEnum.DATE.equals(conditionType) || FilterTypesEnum.TIME.equals(conditionType)) {
                    FilterTypeDateOperatorsEnum dateEnum = FilterTypeDateOperatorsEnum.getByEnumConstantName(condition.getConditionTypeOperator());
                    boolean containsBetween = FilterTypeDateOperatorsEnum.IS_BETWEEN.equals(dateEnum) || FilterTypeDateOperatorsEnum.IS_NOT_BETWEEN.equals(dateEnum);
                    try {
                        DateFormat df = formatFactory.createDateFormat(cfd.getConditionPattern(), locale, null);
                        df.setLenient(false);
                        if (containsBetween) {
                            if (condition.getConditionStart() == null || condition.getConditionStart().length() == 0) {
                                this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.empty.start.date", i + 1);
                            } else {
                                try {
                                    df.parse(condition.getConditionStart());
                                }
                                catch (ParseException e) {
                                    this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.start.date", i + 1, condition.getConditionStart());
                                }
                            }
                            if (condition.getConditionEnd() != null && condition.getConditionEnd().length() > 0) {
                                try {
                                    df.parse(condition.getConditionEnd());
                                }
                                catch (ParseException e) {
                                    this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.end.date", i + 1, condition.getConditionEnd());
                                }
                                continue;
                            }
                            this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.empty.end.date", i + 1);
                            continue;
                        }
                        if (condition.getConditionStart() == null || condition.getConditionStart().length() == 0) {
                            this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.empty.date", i + 1);
                            continue;
                        }
                        try {
                            df.parse(condition.getConditionStart());
                        }
                        catch (ParseException e) {
                            this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.date", i + 1, condition.getConditionStart());
                        }
                    }
                    catch (IllegalArgumentException e) {
                        this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.pattern", i + 1);
                    }
                    continue;
                }
                if (conditionType != FilterTypesEnum.NUMERIC) continue;
                if (condition.getConditionStart() == null || condition.getConditionStart().trim().length() == 0) {
                    this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.empty.number", i + 1);
                    continue;
                }
                try {
                    NumberFormat nf = formatFactory.createNumberFormat(cfd.getConditionPattern(), locale);
                    nf.parse(condition.getConditionStart());
                    if (condition.getConditionEnd() == null || condition.getConditionEnd().length() <= 0) continue;
                    try {
                        nf.parse(condition.getConditionEnd());
                    }
                    catch (ParseException e) {
                        this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.number", i + 1, condition.getConditionEnd());
                    }
                    continue;
                }
                catch (ParseException e) {
                    this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.number", i + 1, condition.getConditionStart());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.conditionalformatting.invalid.pattern", i + 1);
                }
            }
        }
    }
}

