/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package nylon.report;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/**
 *
 * @author SOMCHIT
 */
public class iReport {

    public enum ExportMode {
        PDF,
        EXCEL,
        WORD
    }

    private InputStream ReportJrxml;
    private String ReportJrxmlName;
    private JasperPrint jpPrint;
    private Object reportData;
    private Object parameter;
    private ExportMode exportMode = ExportMode.PDF;

    public iReport() {
        // parameters = new HashMap<>();
    }

    public String export(String reportName, String type, Object data, Object parameter) {
        System.out.println(System.getProperty("user.dir"));
        if (null == type.toLowerCase()) {
            exportMode = ExportMode.PDF;
        } else //  parameters = new HashMap<>();
        {
            switch (type.toLowerCase()) {
                case "pdf":
                    exportMode = ExportMode.PDF;
                    break;
                case "word":
                    exportMode = ExportMode.WORD;
                    break;
                case "excel":
                    exportMode = ExportMode.EXCEL;
                    break;
                default:
                    exportMode = ExportMode.PDF;
                    break;
            }
        }
        this.ReportJrxmlName = reportName;
        this.reportData = data;
        this.parameter = parameter;

        return  byteArrayToHex(this.exporter());
    }

    public String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b & 0xff));
        }
        return sb.toString();
    }
//    public Map<String, Object> getParameter() {
//        return parameters;
//    }

    private Map<String, Object> getParameter() {
        if (this.parameter.getClass() == String.class) {
            return this.getParameterFromJSON();
        } else {
            return this.getParameterFromObject();
        }
    }

    private Map<String, Object> getParameterFromObject() {
        Map<String, Object> pm = new HashMap<>();
        Class cls = parameter.getClass();
        while (cls != null) {
            Field[] fileds = cls.getDeclaredFields();
            int n = fileds.length;
            for (int j = 0; j < n; j++) {

                try {
                    if (!fileds[j].getName().equals("serialVersionUID")
                            && !fileds[j].getName().startsWith("jdo")) {
                        fileds[j].setAccessible(true);
                        pm.put(fileds[j].getName(), fileds[j].get(parameter));
                        fileds[j].setAccessible(false);
                    }
                } catch (SecurityException | IllegalArgumentException | IllegalAccessException ex) {
                    Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
                }
            }
            cls = cls.getSuperclass();
        }
        return pm;

    }

    private Map<String, Object> getParameterFromJSON() {
        Map<String, Object> pms = new HashMap<>();
        JSONObject pm = null;
        try {
            pm = new JSONObject(parameter.toString());
            Iterator e = pm.keys();
            while (e.hasNext()) {
                String name = (String) e.next();
                try {
                    pms.put(name, pm.get(name));
                } catch (JSONException ex) {
                    Logger.getLogger(iReport.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } catch (JSONException ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.SEVERE, null, ex);
        }
        return pms;
    }

//    public void setParameter(Map<String, Object> parameters) {
//        this.parameters = parameters;
//    }
//
//    public ExportMode getExportMode() {
//        return exportMode;
//    }
//
//    public void setExportMode(ExportMode exportMode) {
//        this.exportMode = exportMode;
//    }
//
//    public InputStream getReportJrxml() {
//        return ReportJrxml;
//    }
//
//    public List<?> getReportData() {
//        return reportData;
//    }
//
//    public void setReportData(List<?> reportData) {
//        this.reportData = reportData;
//    }
//    public void setReport(String ReportJrxmlName) {
//        this.ReportJrxmlName = ReportJrxmlName;
//    }
//
//    public void setReport(InputStream ReportJrxml) {
//        this.ReportJrxml = ReportJrxml;
//    }
    private void getReport() {
        try {
            this.ReportJrxml = new FileInputStream(this.ReportJrxmlName);
        } catch (FileNotFoundException ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.ReportJrxmlName.endsWith(".jrxml")) {
            this.getReportJRXML();
        } else {
            this.getReportJASPER();
        }
    }

    private void getReportJASPER() {
        JasperReport jpReport;

        JRDataSource jpData;
        Map<String, Object> jpParam;
        try {
            jpData = this.getDataCollection();
            jpParam = this.getParameter();
            jpReport = (JasperReport) JRLoader.loadObject(this.ReportJrxml);
            jpPrint = JasperFillManager.fillReport(jpReport, jpParam, jpData);

        } catch (Exception ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void getReportJRXML() {
        JasperReport jpReport;
        JRDataSource jpData;
        Map<String, Object> jpParam;
        try {
            jpData = this.getDataCollection();
            jpParam = this.getParameter();
            jpReport = JasperCompileManager.compileReport(this.ReportJrxml);
            jpPrint = JasperFillManager.fillReport(jpReport, jpParam, jpData);
        } catch (JRException ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
        }
    }

//    public Object Export(Class _assembly, String CurrentPaht) {
//        this.ReportJrxml = _assembly.getResourceAsStream(this.ReportJrxmlName);
//        return this.Export();
//    }
    private byte[] exporter() {
        byte[] output;
        switch (this.exportMode) {
            case PDF:
                output = exportToPdf();
                break;
            case EXCEL:
                output = exportToExcel();
                break;
            case WORD:
                output = exportToWord();
                break;
            default:
                output = exportToPdf();
                break;
        }
        return output;
    }

    private byte[] exportToPdf() {

        try {
            if (this.jpPrint == null) {
                this.getReport();
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JRPdfExporter exporter = null;
            exporter = new JRPdfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, jpPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, outputStream);
            exporter.exportReport();
            byte[] out = outputStream.toByteArray();
            return out;

        } catch (JRException ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    private byte[] exportToExcel() {
        {
            try {
                if (this.jpPrint == null) {
                    this.getReport();
                }
                ByteArrayOutputStream excelOutput = new ByteArrayOutputStream();
                JRXlsxExporter exporterXLS = new JRXlsxExporter();
                exporterXLS.setParameter(JRXlsExporterParameter.JASPER_PRINT, jpPrint);
                exporterXLS.setParameter(JRXlsExporterParameter.OUTPUT_STREAM, excelOutput);
                exporterXLS.setParameter(JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.FALSE);
                exporterXLS.setParameter(JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.FALSE);
                exporterXLS.setParameter(JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, Boolean.TRUE);
                exporterXLS.exportReport();
                byte[] out = excelOutput.toByteArray();

                return out;
            } catch (JRException ex) {
                Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
            } finally {

            }
        }
        return null;
    }

    private byte[] exportToWord() {
        {
            try {
                if (this.jpPrint == null) {
                    this.getReport();
                }
                ByteArrayOutputStream excelOutput = new ByteArrayOutputStream();

                JRDocxExporter exporterXLS = new JRDocxExporter();
                exporterXLS.setParameter(JRXlsExporterParameter.JASPER_PRINT, jpPrint);
                exporterXLS.setParameter(JRXlsExporterParameter.OUTPUT_STREAM, excelOutput);
                exporterXLS.setParameter(JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.FALSE);
                exporterXLS.setParameter(JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.FALSE);
                exporterXLS.setParameter(JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, Boolean.TRUE);
                exporterXLS.exportReport();
                byte[] out = excelOutput.toByteArray();
                return out;
            } catch (JRException ex) {
                Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
            } finally {

            }
        }
        return null;
    }

    private List getData() {
        if (this.reportData.getClass() == String.class) {
            return this.getDateFromJson();
        } else {
            return this.getDataFromArray();
        }
    }

    private List getDataFromArray() {
        List listdata = new ArrayList();
        List<?> data = (List<?>) this.reportData;
        data.stream().map((reportData1) -> {
            Class cls = reportData1.getClass();
            Map<String, Object> pmap = new HashMap<>();
            while (cls != null) {
                Field[] fileds = cls.getDeclaredFields();
                int n = fileds.length;

                for (int j = 0; j < n; j++) {
                    try {
                        if (!fileds[j].getName().equals("serialVersionUID")
                                && !fileds[j].getName().startsWith("jdo")) {
                            fileds[j].setAccessible(true);
                            pmap.put(fileds[j].getName(), fileds[j].get(reportData1));
                            fileds[j].setAccessible(false);
                        }
                    } catch (SecurityException | IllegalArgumentException | IllegalAccessException ex) {
                        Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
                cls = cls.getSuperclass();
            }
            return pmap;
        }).forEachOrdered((pmap) -> {
            listdata.add(pmap);
        });
        return listdata;
    }

    private List getDateFromJson() {
        List listdata = new ArrayList();
        if (null != this.reportData) {
            JSONArray d = null;

            try {
                d = new JSONArray(this.reportData.toString());
                for (int i = 0; i < d.length(); i++) {
                    Map<String, Object> obj = new HashMap<>();
                    try {
                        JSONObject dd = d.getJSONObject(i);
                        Iterator e = dd.keys();
                        while (e.hasNext()) {
                            String name = (String) e.next();
                            try {
                                obj.put(name, dd.get(name));
                            } catch (JSONException ex) {
                                Logger.getLogger(iReport.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    } catch (JSONException ex) {
                        Logger.getLogger(iReport.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    listdata.add(obj);
                }
            } catch (JSONException ex) {
                Logger.getLogger(iReport.class.getName()).log(Level.SEVERE, null, ex);
            }

        }
        return listdata;
    }

    private JRMapCollectionDataSource getDataCollection() {
        JRMapCollectionDataSource datas = new JRMapCollectionDataSource(this.getData());
        return datas;
    }
}
