/*
 * Decompiled with CFR 0.152.
 */
package nylon.report;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class iReport {
    private InputStream ReportJrxml;
    private String ReportJrxmlName;
    private JasperPrint jpPrint;
    private Object reportData;
    private Object parameter;
    private ExportMode exportMode = ExportMode.PDF;

    public String export(String reportName, String type, Object data, Object parameter) {
        System.out.println(System.getProperty("user.dir"));
        if (null == type.toLowerCase()) {
            this.exportMode = ExportMode.PDF;
        } else {
            switch (type.toLowerCase()) {
                case "pdf": {
                    this.exportMode = ExportMode.PDF;
                    break;
                }
                case "word": {
                    this.exportMode = ExportMode.WORD;
                    break;
                }
                case "excel": {
                    this.exportMode = ExportMode.EXCEL;
                    break;
                }
                default: {
                    this.exportMode = ExportMode.PDF;
                }
            }
        }
        this.ReportJrxmlName = reportName;
        this.reportData = data;
        this.parameter = parameter;
        return this.byteArrayToHex(this.exporter());
    }

    public String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    private Map<String, Object> getParameter() {
        if (this.parameter.getClass() == String.class) {
            return this.getParameterFromJSON();
        }
        return this.getParameterFromObject();
    }

    private Map<String, Object> getParameterFromObject() {
        HashMap<String, Object> pm = new HashMap<String, Object>();
        for (Class<?> cls = this.parameter.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field[] fileds = cls.getDeclaredFields();
            int n = fileds.length;
            for (int j = 0; j < n; ++j) {
                try {
                    if (fileds[j].getName().equals("serialVersionUID") || fileds[j].getName().startsWith("jdo")) continue;
                    fileds[j].setAccessible(true);
                    pm.put(fileds[j].getName(), fileds[j].get(this.parameter));
                    fileds[j].setAccessible(false);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                    Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
                }
            }
        }
        return pm;
    }

    private Map<String, Object> getParameterFromJSON() {
        HashMap<String, Object> pms = new HashMap<String, Object>();
        JSONObject pm = null;
        try {
            pm = new JSONObject(this.parameter.toString());
            Iterator e = pm.keys();
            while (e.hasNext()) {
                String name = (String)e.next();
                try {
                    pms.put(name, pm.get(name));
                }
                catch (JSONException ex) {
                    Logger.getLogger(iReport.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.SEVERE, null, ex);
        }
        return pms;
    }

    private void getReport() {
        try {
            this.ReportJrxml = new FileInputStream(this.ReportJrxmlName);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.ReportJrxmlName.endsWith(".jrxml")) {
            this.getReportJRXML();
        } else {
            this.getReportJASPER();
        }
    }

    private void getReportJASPER() {
        try {
            JRMapCollectionDataSource jpData = this.getDataCollection();
            Map<String, Object> jpParam = this.getParameter();
            JasperReport jpReport = (JasperReport)JRLoader.loadObject((InputStream)this.ReportJrxml);
            this.jpPrint = JasperFillManager.fillReport((JasperReport)jpReport, jpParam, (JRDataSource)jpData);
        }
        catch (Exception ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void getReportJRXML() {
        try {
            JRMapCollectionDataSource jpData = this.getDataCollection();
            Map<String, Object> jpParam = this.getParameter();
            JasperReport jpReport = JasperCompileManager.compileReport((InputStream)this.ReportJrxml);
            this.jpPrint = JasperFillManager.fillReport((JasperReport)jpReport, jpParam, (JRDataSource)jpData);
        }
        catch (JRException ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private byte[] exporter() {
        byte[] output;
        switch (this.exportMode) {
            case PDF: {
                output = this.exportToPdf();
                break;
            }
            case EXCEL: {
                output = this.exportToExcel();
                break;
            }
            case WORD: {
                output = this.exportToWord();
                break;
            }
            default: {
                output = this.exportToPdf();
            }
        }
        return output;
    }

    private byte[] exportToPdf() {
        try {
            if (this.jpPrint == null) {
                this.getReport();
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JRPdfExporter exporter = null;
            exporter = new JRPdfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.jpPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
            exporter.exportReport();
            byte[] out = outputStream.toByteArray();
            return out;
        }
        catch (JRException ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] exportToExcel() {
        try {
            byte[] out;
            if (this.jpPrint == null) {
                this.getReport();
            }
            ByteArrayOutputStream excelOutput = new ByteArrayOutputStream();
            JRXlsxExporter exporterXLS = new JRXlsxExporter();
            exporterXLS.setParameter(JRXlsExporterParameter.JASPER_PRINT, (Object)this.jpPrint);
            exporterXLS.setParameter(JRXlsExporterParameter.OUTPUT_STREAM, (Object)excelOutput);
            exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
            exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
            exporterXLS.exportReport();
            byte[] byArray = out = excelOutput.toByteArray();
            return byArray;
        }
        catch (JRException ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] exportToWord() {
        try {
            byte[] out;
            if (this.jpPrint == null) {
                this.getReport();
            }
            ByteArrayOutputStream excelOutput = new ByteArrayOutputStream();
            JRDocxExporter exporterXLS = new JRDocxExporter();
            exporterXLS.setParameter(JRXlsExporterParameter.JASPER_PRINT, (Object)this.jpPrint);
            exporterXLS.setParameter(JRXlsExporterParameter.OUTPUT_STREAM, (Object)excelOutput);
            exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
            exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
            exporterXLS.exportReport();
            byte[] byArray = out = excelOutput.toByteArray();
            return byArray;
        }
        catch (JRException ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
        }
        return null;
    }

    private List getData() {
        if (this.reportData.getClass() == String.class) {
            return this.getDateFromJson();
        }
        return this.getDataFromArray();
    }

    private List getDataFromArray() {
        ArrayList listdata = new ArrayList();
        List data = (List)this.reportData;
        data.stream().map(reportData1 -> {
            HashMap<String, Object> pmap = new HashMap<String, Object>();
            for (Class<?> cls = reportData1.getClass(); cls != null; cls = cls.getSuperclass()) {
                Field[] fileds = cls.getDeclaredFields();
                int n = fileds.length;
                for (int j = 0; j < n; ++j) {
                    try {
                        if (fileds[j].getName().equals("serialVersionUID") || fileds[j].getName().startsWith("jdo")) continue;
                        fileds[j].setAccessible(true);
                        pmap.put(fileds[j].getName(), fileds[j].get(reportData1));
                        fileds[j].setAccessible(false);
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                        Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
            }
            return pmap;
        }).forEachOrdered(pmap -> listdata.add(pmap));
        return listdata;
    }

    private List getDateFromJson() {
        ArrayList listdata = new ArrayList();
        if (null != this.reportData) {
            JSONArray d = null;
            try {
                d = new JSONArray(this.reportData.toString());
                for (int i = 0; i < d.length(); ++i) {
                    HashMap<String, Object> obj = new HashMap<String, Object>();
                    try {
                        JSONObject dd = d.getJSONObject(i);
                        Iterator e = dd.keys();
                        while (e.hasNext()) {
                            String name = (String)e.next();
                            try {
                                obj.put(name, dd.get(name));
                            }
                            catch (JSONException ex) {
                                Logger.getLogger(iReport.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(iReport.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    listdata.add(obj);
                }
            }
            catch (JSONException ex) {
                Logger.getLogger(iReport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return listdata;
    }

    private JRMapCollectionDataSource getDataCollection() {
        JRMapCollectionDataSource datas = new JRMapCollectionDataSource((Collection)this.getData());
        return datas;
    }

    public static enum ExportMode {
        PDF,
        EXCEL,
        WORD;

    }
}

