const work_dir=process.cwd();
var stream = require('stream');
const java = require('./java');
module.exports=function(app){
    app.use(function(req,res,next){
        //var iReport=req._jvm.import("nylon.report.iReport");
        //var rp=new iReport();

         res._ireport=function(reportName,type,datas,parameters){
            var iReport=java.jvm.import("nylon.report.iReport");
            reportName=work_dir+"/app/reports/"+reportName;
            var rp=new iReport();
            rp.export(reportName,type,JSON.stringify(datas),JSON.stringify(parameters),
                function(err,buff){
                    var buffer= Buffer.from(buff, "hex");
                    res._responseFile(buffer,type);
                }
            );
        }

        res._responseFile=function(buffer,type){
               var bufferStream = new stream.PassThrough();
               bufferStream.end( buffer );
               this.setHeader('Content-Length', buffer.length);
               var fname=req._guid();
               if(type=="pdf"){
                   this.setHeader('Content-Type', 'application/pdf');
               }else if(type=='excel'){
                   this.setHeader('Content-Type', 'application/octet-stream');
                   this.setHeader('Content-Disposition', 'attachment; filename='+fname+'.xlsx');
               }else if(type=='word'){
                   this.setHeader('Content-Type', 'application/octet-stream');
                   this.setHeader('Content-Disposition', 'attachment; filename='+fname+'.docx');
               }else{
                   this.setHeader('Content-Type', 'application/pdf');
                   this.setHeader('Content-Disposition', 'attachment; filename='+fname+'.pdf');
               }
              bufferStream.pipe(this);
        }

        req._guid=function() {
                function s4() {
                    return Math.floor((1 + Math.random()) * 0x10000)
                    .toString(16)
                    .substring(1);
                }
                return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
                    s4() + '-' + s4() + s4() + s4();
       }

        next();
    });
}