/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import net.sf.jasperreports.components.barcode4j.QRCodeBean;
import net.sf.jasperreports.components.barcode4j.QRCodeImageProducer;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.util.RendererUtil;

public class QRCodeRasterizedImageProducer
implements QRCodeImageProducer {
    @Override
    public Renderable createImage(JasperReportsContext jasperReportsContext, JRComponentElement componentElement, QRCodeBean qrCodeBean, String message) {
        QRCodeWriter writer = new QRCodeWriter();
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, qrCodeBean.getErrorCorrectionLevel().getErrorCorrectionLevel());
        int margin = qrCodeBean.getMargin() == null ? 4 : qrCodeBean.getMargin();
        hints.put(EncodeHintType.MARGIN, margin);
        int resolution = JRPropertiesUtil.getInstance(jasperReportsContext).getIntegerProperty(componentElement, "net.sf.jasperreports.components.barcode4j.image.resolution", 300);
        try {
            BitMatrix matrix = writer.encode(message, BarcodeFormat.QR_CODE, (int)((float)resolution / 72.0f * (float)componentElement.getWidth()), (int)((float)resolution / 72.0f * (float)componentElement.getHeight()), hints);
            BufferedImage image = this.getImage(matrix, componentElement.getForecolor());
            return RendererUtil.getInstance(jasperReportsContext).getRenderable(image, ImageTypeEnum.PNG, OnErrorTypeEnum.ERROR);
        }
        catch (WriterException e) {
            throw new JRRuntimeException(e);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    public BufferedImage getImage(BitMatrix matrix, Color onColor) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        int onArgb = JRColorUtil.getOpaqueArgb(onColor, Color.BLACK);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (!matrix.get(x, y)) continue;
                image.setRGB(x, y, onArgb);
            }
        }
        return image;
    }
}

