/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/
process.env.NODE_ENV=process.env.NODE_ENV || 'development';
const cluster = require('cluster');
const config=require(process.cwd()+'/config/config');

const watcher=require('./watcher');
const validator=require('./validator');
const rethinkdb=require('./rethinkdb');
const express =require('./express');
const express_route =require('./express-load-route');
const http=require('http');
const passport =require('./passport');
const java = require('./java');
const iReport = require('./iReport');
const socket = require('./socket');
const http2 =require('spdy');
const fs =require('fs');
var logger = require('winston');
const work_dir=process.cwd();

var now = new Date();
var logger_f="L"+now.getFullYear() + now.getMonth()+ now.getDate();

logger.configure({
    transports: [
      new (logger.transports.Console)(),
      new (logger.transports.File)({ filename: work_dir+'/loggers/'+logger_f+".log" })
    ]
});



exports.serve= function(path){
    if (cluster.isMaster) {
        
        for (var i = 0; i < config.server.cluster; i++) {
            cluster.fork();
        }

        cluster.on('exit', (worker, code, signal) => {
            cluster.fork();
            logger.info('worker '+worker.process.pid+' died');
        });

       watcher.addWatcher(process.cwd()+'/app');
       watcher.addWatcher(process.cwd()+'/config');

    }else{
        var fs_package = require('fs');
        var manifest = JSON.parse(fs.readFileSync(process.cwd()+'/public/manifest.json', 'utf8'));
        
        validator.loadSchema(process.cwd()+'/app/models');
        java.loadJava(path+"/java");

        var db  = rethinkdb(config);
        var app = express(db,config,validator.ajv,java.jvm,manifest);

        require('./express-load-route')(app);
        require('./iReport')(app);
        require('./oauth/oauth.routes')(app);

        var server =http.createServer(app); 

        var options = {
            key: fs.readFileSync(__dirname + '/ssl/server.key'),
            cert: fs.readFileSync(__dirname + '/ssl/server.crt'),
            spdy: {
                    protocols: [ 'h2', 'spdy/3.1'],
                    plain: false,
                    'x-forwarded-for': true,
                    connection: {
                    windowSize: 1024 * 1024, 
                    autoSpdy31: false
                }
            }
        };

        var oauth=passport(db,config);
        
        server.listen(config.server.port, function (error) {
            if(error){
                logger.error( error);
            }else{
                logger.info('Nylon server listening on port ' + config.server.port + ' pid '+process.pid);
            }

            
        });


        process.on('uncaughtException', function(err){
            logger.error( err);
            process.exit(1);
        });

        module.exports=app;
    }
}
