/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/

const work_dir=process.cwd();
const route_dir="/app/routes";
var fs=require('fs');
var express=require('express');

function loadRouter(path,prefix,app){
    return new Promise((resolve, reject) => {

        fs.readdir(path, function(err, files) { 
                    files.forEach(function(filename) {                   
                            if(filename!=="."){
                                fs.stat(path +"/"+ filename, function(err, stats) {
                                    if (!err) {
                                        if(stats.isDirectory()){
                                            prefix=prefix+"/"+filename;
                                            loadRouter(path+"/"+filename,prefix,app);
                                        }else{
                                            if(filename.endsWith(".routes.js")){
                                                    console.log("nylon start route :: "+ filename);
                                                    var rname=filename.replace(".routes.js","");
                                                    var router = express.Router();
                                                    require(path+"/"+filename)(router);
                                                    app.use(prefix+"/"+rname, router);
                                                    console.log(prefix+"/"+rname);
                                            }
                                        }
                                    }
                                });
                            }
                    });
        });

    });
}
module.exports=function(app){
     loadRouter(work_dir+route_dir,"/api",app);
}