/*
 * Decompiled with CFR 0.152.
 */
package nylon.report;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class NumberFormat {
    private final String[] DIGIT_TH = new String[]{"0", "\u0e51", "\u0e52", "\u0e53", "\u0e54", "\u0e55", "\u0e56", "\u0e57", "\u0e58", "\u0e59"};
    private final String[] tensNames = new String[]{"", " ten", " twenty", " thirty", " forty", " fifty", " sixty", " seventy", " eighty", " ninety"};
    private final String[] numNames = new String[]{"", " one", " two", " three", " four", " five", " six", " seven", " eight", " nine", " ten", " eleven", " twelve", " thirteen", " fourteen", " fifteen", " sixteen", " seventeen", " eighteen", " nineteen"};

    public String toThaiNumber(Object amountx) {
        String amount = String.valueOf(amountx);
        if (amount == null || amount.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : amount.toCharArray()) {
            if (Character.isDigit(c)) {
                String index = this.DIGIT_TH[Character.getNumericValue(c)].toString();
                sb.append(index);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String toFormat(Object obj, String format) {
        DecimalFormat df = new DecimalFormat(format);
        String x = df.format(obj);
        return x;
    }

    public String toDateThai(String strDate) {
        String[] Months = new String[]{"\u0e21\u0e01\u0e23\u0e32\u0e04\u0e21", "\u0e01\u0e38\u0e21\u0e20\u0e32\u0e1e\u0e31\u0e19\u0e18\u0e4c", "\u0e21\u0e35\u0e19\u0e32\u0e04\u0e21", "\u0e40\u0e21\u0e29\u0e32\u0e22\u0e19", "\u0e1e\u0e24\u0e29\u0e20\u0e32\u0e04\u0e21", "\u0e21\u0e34\u0e16\u0e38\u0e19\u0e32\u0e22\u0e19", "\u0e01\u0e23\u0e01\u0e0e\u0e32\u0e04\u0e21", "\u0e2a\u0e34\u0e07\u0e2b\u0e32\u0e04\u0e21", "\u0e01\u0e31\u0e19\u0e22\u0e32\u0e22\u0e19", "\u0e15\u0e38\u0e25\u0e32\u0e04\u0e21", "\u0e1e\u0e24\u0e28\u0e08\u0e34\u0e01\u0e32\u0e22\u0e19", "\u0e18\u0e31\u0e19\u0e27\u0e32\u0e04\u0e21"};
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        int year = 0;
        int month = 0;
        int day = 0;
        try {
            Date date = df.parse(strDate);
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            year = c.get(1);
            month = c.get(2);
            day = c.get(5);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return String.format("%s %s %s", day, Months[month], year + 543);
    }

    public String toDateThaiShort(String strDate) {
        String[] Months = new String[]{"\u0e21.\u0e04", "\u0e01.\u0e1e", "\u0e21\u0e35.\u0e04", "\u0e40\u0e21.\u0e22", "\u0e1e.\u0e04", "\u0e21\u0e34.\u0e22", "\u0e01.\u0e04", "\u0e2a.\u0e04", "\u0e01.\u0e22", "\u0e15.\u0e04", "\u0e1e.\u0e22", "\u0e18.\u0e04"};
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        int year = 0;
        int month = 0;
        int day = 0;
        try {
            Date date = df.parse(strDate);
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            year = c.get(1);
            month = c.get(2);
            day = c.get(5);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return String.format("%s %s %s", day, Months[month], year + 543);
    }

    public String toDateEng(String strDate) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat df2 = new SimpleDateFormat("dd MMMM yyyy", Locale.US);
            Date date = df.parse(strDate);
            return df2.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String toDateEngShort(String strDate) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat df2 = new SimpleDateFormat("dd MMM yyyy", Locale.US);
            Date date = df.parse(strDate);
            return df2.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String toThaiBaht(Object amountx) {
        Double amount;
        String txt = amountx.toString();
        String bahtTH = "";
        try {
            amount = Double.parseDouble(txt);
        }
        catch (Exception ex) {
            amount = 0.0;
        }
        try {
            DecimalFormat df = new DecimalFormat("####.00");
            String bahtTxt = df.format(amount);
            String[] num = new String[]{"\u0e28\u0e39\u0e19\u0e22\u0e4c", "\u0e2b\u0e19\u0e36\u0e48\u0e07", "\u0e2a\u0e2d\u0e07", "\u0e2a\u0e32\u0e21", "\u0e2a\u0e35\u0e48", "\u0e2b\u0e49\u0e32", "\u0e2b\u0e01", "\u0e40\u0e08\u0e47\u0e14", "\u0e41\u0e1b\u0e14", "\u0e40\u0e01\u0e49\u0e32", "\u0e2a\u0e34\u0e1a"};
            String[] rank = new String[]{"", "\u0e2a\u0e34\u0e1a", "\u0e23\u0e49\u0e2d\u0e22", "\u0e1e\u0e31\u0e19", "\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e41\u0e2a\u0e19", "\u0e25\u0e49\u0e32\u0e19", "\u0e2a\u0e34\u0e1a\u0e25\u0e49\u0e32\u0e19", "\u0e23\u0e49\u0e2d\u0e22\u0e25\u0e49\u0e32\u0e19", "\u0e1e\u0e31\u0e19\u0e25\u0e49\u0e32\u0e19", "\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e25\u0e49\u0e32\u0e19", "\u0e41\u0e2a\u0e19\u0e25\u0e49\u0e32\u0e19"};
            String[] temp = bahtTxt.split("[.]");
            String intVal = temp[0];
            String decVal = temp[1];
            if (Double.parseDouble(bahtTxt) == 0.0) {
                bahtTH = "\u0e28\u0e39\u0e19\u0e22\u0e4c\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19";
            } else {
                String n;
                int i;
                for (i = 0; i < intVal.length(); ++i) {
                    n = intVal.substring(i, i + 1);
                    if (n == "0") continue;
                    bahtTH = i == intVal.length() - 1 && n == "1" ? bahtTH + "\u0e40\u0e2d\u0e47\u0e14" : (i == intVal.length() - 2 && n == "2" ? bahtTH + "\u0e22\u0e35\u0e48" : (i == intVal.length() - 2 && n == "1" ? bahtTH + "" : bahtTH + num[Integer.parseInt(n)]));
                    bahtTH = bahtTH + rank[intVal.length() - i - 1];
                }
                bahtTH = bahtTH + "\u0e1a\u0e32\u0e17";
                if (decVal == "00") {
                    bahtTH = bahtTH + "\u0e16\u0e49\u0e27\u0e19";
                } else {
                    for (i = 0; i < decVal.length(); ++i) {
                        n = decVal.substring(i, i + 1);
                        if (n == "0") continue;
                        bahtTH = i == decVal.length() - 1 && n == "1" ? bahtTH + "\u0e40\u0e2d\u0e47\u0e14" : (i == decVal.length() - 2 && n == "2" ? bahtTH + "\u0e22\u0e35\u0e48" : (i == decVal.length() - 2 && n == "1" ? bahtTH + "" : bahtTH + num[Integer.parseInt(n)]));
                        bahtTH = bahtTH + rank[decVal.length() - i - 1];
                    }
                    bahtTH = bahtTH + "\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c";
                }
            }
        }
        catch (Exception exe) {
            System.out.print(exe.getMessage());
        }
        return bahtTH;
    }

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = this.numNames[number % 100];
            number /= 100;
        } else {
            soFar = this.numNames[number % 10];
            soFar = this.tensNames[(number /= 10) % 10] + soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        return this.numNames[number] + " hundred" + soFar;
    }

    public String toEngString(long number) {
        String tradHundredThousands;
        String tradMillions;
        String tradBillions;
        if (number == 0L) {
            return "zero";
        }
        String snumber = Long.toString(number);
        String mask = "000000000000";
        DecimalFormat df = new DecimalFormat(mask);
        snumber = df.format(number);
        int billions = Integer.parseInt(snumber.substring(0, 3));
        int millions = Integer.parseInt(snumber.substring(3, 6));
        int hundredThousands = Integer.parseInt(snumber.substring(6, 9));
        int thousands = Integer.parseInt(snumber.substring(9, 12));
        switch (billions) {
            case 0: {
                tradBillions = "";
                break;
            }
            case 1: {
                tradBillions = this.convertLessThanOneThousand(billions) + " billion ";
                break;
            }
            default: {
                tradBillions = this.convertLessThanOneThousand(billions) + " billion ";
            }
        }
        String result = tradBillions;
        switch (millions) {
            case 0: {
                tradMillions = "";
                break;
            }
            case 1: {
                tradMillions = this.convertLessThanOneThousand(millions) + " million ";
                break;
            }
            default: {
                tradMillions = this.convertLessThanOneThousand(millions) + " million ";
            }
        }
        result = result + tradMillions;
        switch (hundredThousands) {
            case 0: {
                tradHundredThousands = "";
                break;
            }
            case 1: {
                tradHundredThousands = "one thousand ";
                break;
            }
            default: {
                tradHundredThousands = this.convertLessThanOneThousand(hundredThousands) + " thousand ";
            }
        }
        result = result + tradHundredThousands;
        String tradThousand = this.convertLessThanOneThousand(thousands);
        result = result + tradThousand;
        return result.replaceAll("^\\s+", "").replaceAll("\\b\\s{2,}\\b", " ").toUpperCase();
    }

    public static void main(String[] args) {
        System.out.println(" toThaiNumber -1257.5463 : " + new NumberFormat().toThaiNumber(-1257.5463));
        System.out.println("toFormat 1234.5463 : " + new NumberFormat().toFormat(1234.5463, "#,##0.00"));
        System.out.println("toDateThai 2016-12-31 : " + new NumberFormat().toDateThai("2016-12-31"));
        System.out.println("toDateThaiShort 2016-12-31 : " + new NumberFormat().toDateThaiShort("2016-12-31"));
        System.out.println("toDateEng 2016-12-31 : " + new NumberFormat().toDateEng("2016-12-31"));
        System.out.println(" toDateEngShort 2016-12-31 : " + new NumberFormat().toDateEngShort("2016-12-31"));
        System.out.println("toThaiBaht 123456789.23 : " + new NumberFormat().toThaiBaht(1.2348912123123E11));
        System.out.println("toEngString 1234891 : " + new NumberFormat().toEngString(1234891L));
    }
}

