/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/

const work_dir=process.cwd();
var express=require('express');
var morgan=require('morgan');
var compression=require('compression');
var bodyParser=require('body-parser');
var sass=require('node-sass-middleware');
var fs=require('fs');
var session = require('express-session');
var RDBStore = require('./rethinkdb-session')(session);
var passport = require('passport');
var logger = require('winston');
//const global_dir="/app/global";


module.exports=function(db,config,validator,jvm,manifest){
    var app = express();
    //console.log(validate_model);

   logger.info("nylon Server run at env : "+process.env.NODE_ENV);

    var rdbStore = new RDBStore({
            connection: db,
            db: 'oauth',
            table: 'session',
            sessionTimeout: 86400000,
            flushInterval: 60000,
            debug: false
    });


    app.use(session({
            resave: false,
            saveUninitialized: true,
            key: 'sid',
            secret: 'my5uperSEC537(key)!',
            cookie: { maxAge: 860000 },
            store: rdbStore
    }));

    app.use(passport.initialize());
    app.use(passport.session());

    if (process.env.NODE_ENV === 'development') {
        app.use(morgan('dev'));
    }else{
         app.use(compression());
    }



    app.use(bodyParser.urlencoded({ extended: true }));
    app.use(bodyParser.json());

    
   /* var globals = fs.readdirSync(work_dir+global_dir);
    for (var i in globals){
        if(globals[i].endsWith(".js")){
            var r = global_dir + '/' + routes[i];
            var gfun=require(work_dir+r);
            console.log("nylon global :: "+r);
        }
    }*/

    app.use(function(req,res,next){
         logger.info("client req "+req.url);

         req._r=db;
         req._config=config;
         req._validator=validator;
         req._jvm=jvm;
         req._logger=logger;
         next();

    });

    app.set('views',work_dir+'/app/views');
    app.set('view engine','jade');


    app.use(sass({
        src:work_dir+'/sass',
        dest:work_dir+'/public/css',
        outputStyle:'compressed',
        prefix:'/css'
    }));

    return app;
}
