/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/

const fs = require('fs');
const Ajv = require('ajv');
const ajv = Ajv({ allErrors: true});

const loadSchema=function(path){

    fs.readdir(path, function(err, files) { 
        files.forEach(function(filename) {
            
                if(filename!=="."){
                    fs.stat(path +"/"+ filename, function(err, stats) {
                        
                        if (!err) {
                            if(stats.isDirectory()){
                                loadSchema(path+"/"+filename);
                            }else{
                            
                                if(filename.endsWith(".model.json")){
                                    console.log("Load Data Mode :: "+ filename);
                                    fs.readFile(path+"/"+filename, 'utf8', function (err, data) {
                                        if (err) throw err;
                                        obj = JSON.parse(data);
                                        ajv.addSchema(obj, obj.name);
                                        // resolve(ajv);
                                    });

                                }
                            }
                        }
                        else{

                        }

                    });
                }
        });
    });
    
}

exports.loadSchema=loadSchema;
exports.ajv=ajv;