/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/

const work_dir=process.cwd();
const route_dir="/app/routes";
var fs=require('fs');
var express=require('express');
var URL = require('url');

function loadRouter(path,prefix,app){
    return new Promise((resolve, reject) => {

        fs.readdir(path, function(err, files) { 
                    files.forEach(function(filename) {                   
                            if(filename!=="."){
                                fs.stat(path +"/"+ filename, function(err, stats) {
                                    if (!err) {
                                        if(stats.isDirectory()){
                                            var prefixx=prefix+"/"+filename;
                                            resolve(loadRouter(path+"/"+filename,prefixx,app));
                                        }else{
                                            if(filename.endsWith(".routes.js")){
                                                 // path.dirname(require.main.filename);
                                                    console.log("nylon start route :: "+ filename);
                                                    var rname=filename.replace(".routes.js","");
                                                    var router = express.Router();
                                                    require(path+"/"+filename)(router);
                                                    app.use(prefix+"/"+rname, router);
                                                    console.log(prefix+"/"+rname);
                                                    resolve('end of load routes');
                                            }
                                        }
                                    }
                                });
                            }
                    });
           
       });

    });
}
module.exports=function(app){
        loadRouter(work_dir+route_dir,"/api",app).then(function(x){
            console.log(x);
            app.use(express.static(work_dir+'/public'));
            app.use(function (req, res, next) {
                   // if(res.status(404)) {

                    var url = URL.parse(req.url, true).pathname ;
                    if(url.indexOf('api')<0 && url.indexOf('.')<0){
                        res.status(404);
                        res.sendFile(work_dir+'/public/index.html',404);
                    }else{
                        next();
                    }
                   // }else{
                    //    next();
                   // }
            });
        });
}