/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.Locale;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.JRDataUtils;

public class HtmlFontFamily {
    public static final String LOCALE_SEPARATOR = "_-";
    private static final int IE_FONT_NAME_MAX_LENGTH = 31;
    private Locale locale;
    private FontFamily fontFamily;
    private String id;
    private String shortId;

    private HtmlFontFamily(Locale locale, FontFamily fontFamily) {
        this.locale = locale;
        this.fontFamily = fontFamily;
        this.createIds();
    }

    public static HtmlFontFamily getInstance(Locale locale, FontInfo fontInfo) {
        HtmlFontFamily htmlFont = null;
        if (fontInfo != null) {
            FontFamily family = fontInfo.getFontFamily();
            htmlFont = new HtmlFontFamily(locale, family);
        }
        return htmlFont;
    }

    public static HtmlFontFamily getInstance(JasperReportsContext jasperReportsContext, String htmlFontFamilyId) {
        int localeSeparatorPos = htmlFontFamilyId.lastIndexOf(LOCALE_SEPARATOR);
        String familyName = htmlFontFamilyId.substring(0, localeSeparatorPos);
        String localeCode = htmlFontFamilyId.substring(localeSeparatorPos + LOCALE_SEPARATOR.length());
        Locale locale = JRDataUtils.getLocale(localeCode);
        FontInfo fontInfo = FontUtil.getInstance(jasperReportsContext).getFontInfo(familyName, locale);
        return HtmlFontFamily.getInstance(locale, fontInfo);
    }

    private void createIds() {
        String prefix = this.fontFamily.getName();
        String suffix = this.locale == null ? "" : LOCALE_SEPARATOR + JRDataUtils.getLocaleCode(this.locale);
        this.id = prefix + suffix;
        if (prefix.length() + suffix.length() > 31) {
            prefix = prefix.replaceAll("\\s", "");
        }
        if (prefix.length() + suffix.length() > 31) {
            prefix = prefix.substring(0, 1) + prefix.substring(1).replaceAll("[AaEeIiOoUu]", "");
        }
        if (prefix.length() + suffix.length() > 31) {
            prefix = prefix.substring(0, 31 - suffix.length());
        }
        this.shortId = prefix + suffix;
    }

    public String getId() {
        return this.id;
    }

    public String getShortId() {
        return this.shortId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public FontFamily getFontFamily() {
        return this.fontFamily;
    }
}

