/*
 * Decompiled with CFR 0.152.
 */
package nylon.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDBCConnect {
    private Map<String, ConnectString> connections = new HashMap<String, ConnectString>();

    public String addConnection(String name, String driver, String url, String user, String password) {
        try {
            ConnectString connStr = new ConnectString(name, driver, url, user, password);
            this.connections.put(name, connStr);
            return "add Connection ok";
        }
        catch (Exception ex) {
            Logger.getLogger(JDBCConnect.class.getName()).log(Level.SEVERE, null, ex);
            return ex.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String query(String connName, String sql, Object[] params) {
        if (this.connections.containsKey(connName)) {
            Statement stmt = null;
            ArrayList datas = new ArrayList();
            ObjectMapper mapper = new ObjectMapper();
            try {
                Connection connection = this.connections.get(connName).getConnect();
                stmt = connection.prepareStatement(sql);
                if (params.length > 0) {
                    for (int i = 0; i < params.length; ++i) {
                        stmt.setString(i + 1, (String)params[i]);
                    }
                }
                ResultSet rs = stmt.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                while (rs.next()) {
                    int numColumns = rsmd.getColumnCount();
                    HashMap<String, Object> obj = new HashMap<String, Object>();
                    block30: for (int i = 0; i < numColumns; ++i) {
                        String column_name = rsmd.getColumnLabel(i + 1);
                        int column_type = rsmd.getColumnType(i + 1);
                        switch (column_type) {
                            case 2003: {
                                obj.put(column_name, rs.getArray(column_name));
                                continue block30;
                            }
                            case -5: {
                                obj.put(column_name, rs.getInt(column_name));
                                continue block30;
                            }
                            case 16: {
                                obj.put(column_name, rs.getBoolean(column_name));
                                continue block30;
                            }
                            case 2004: {
                                obj.put(column_name, rs.getBlob(column_name));
                                continue block30;
                            }
                            case 8: {
                                obj.put(column_name, rs.getDouble(column_name));
                                continue block30;
                            }
                            case 6: {
                                obj.put(column_name, Float.valueOf(rs.getFloat(column_name)));
                                continue block30;
                            }
                            case 4: {
                                obj.put(column_name, rs.getInt(column_name));
                                continue block30;
                            }
                            case -9: {
                                obj.put(column_name, rs.getNString(column_name));
                                continue block30;
                            }
                            case 12: {
                                obj.put(column_name, rs.getString(column_name));
                                continue block30;
                            }
                            case -6: {
                                obj.put(column_name, rs.getInt(column_name));
                                continue block30;
                            }
                            case 5: {
                                obj.put(column_name, rs.getInt(column_name));
                                continue block30;
                            }
                            case 91: {
                                obj.put(column_name, rs.getDate(column_name));
                                continue block30;
                            }
                            case 93: {
                                obj.put(column_name, rs.getTimestamp(column_name));
                                continue block30;
                            }
                            default: {
                                obj.put(column_name, rs.getObject(column_name));
                            }
                        }
                    }
                    datas.add(obj);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(JDBCConnect.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(JDBCConnect.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            try {
                String json = mapper.writeValueAsString(datas);
                return json;
            }
            catch (JsonProcessingException ex) {
                Logger.getLogger(JDBCConnect.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return "";
    }

    public static void main(String ... argrs) {
    }

    public class ConnectString {
        private String name;
        private String driver;
        private String url;
        private String user;
        private String password;

        public ConnectString(String name, String driver, String url, String user, String password) {
            this.name = name;
            this.driver = driver;
            this.url = url;
            this.user = user;
            this.password = password;
        }

        public Connection getConnect() throws SQLException {
            Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
            return conn;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

