/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/


var express = require('express');
var async = require('async');
//var logger = require('winston');
var fscan = require('./../common/fscan');
//const work_dir = process.cwd();
//const config = require(process.cwd() + '/config/config');

var cookieParser = require('cookie-parser');
const work_dir = process.cwd();
const m_dir = "/app/modules";

module.exports = function (nylon) {
    var logger = nylon.logger;
    logger.info("nylon Server run at env : " + process.env.NODE_ENV);
    var app = express();
    app.use(cookieParser());
    /** load express module */


    app.nylon = nylon;
    // app.nylon.r=db;

    console.log("work_dir::" + nylon.work_dir);

    fscan.scan(nylon.nylon_path + "/lib/modules", ".js", true, function (err, modelues) {
        fscan.scan(work_dir + m_dir, ".module.js", true, function (err, u_modelues) {

            modelues=modelues.concat(u_modelues);
            async.each(modelues, function (modelue, next) {
                try {
                    logger.info("Load Module   :: " + modelue + " Complete!");
                    require(modelue)(app);
                    next();
                } catch (err) {
                    logger.error(err);
                    next(err);
                }
            }, function (err) {

            });
        });


    });
    // console.log(work_dir + m_dir);
    // fscan.scan(work_dir + m_dir, ".module.js", false, function (err, modelues) {
    //     async.each(modelues, function (modelue, next) {
    //         try {
    //             logger.info("Load Module   :: " + modelue + " Complete!");
    //             require(work_dir + m_dir + "/" + modelue)(app);
    //             next();
    //         } catch (err) {
    //             logger.error(err);
    //             next(err);
    //         }
    //     }, function (err) {

    //     });

    // });

    return app;
}