/*
 * Decompiled with CFR 0.152.
 */
package nylon.report;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JsonDataSource;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXml4SwfExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXmlExporterOutput;

public class iReport {
    public String export(String reportFile, String exportMode, String datas, String parameters) {
        try {
            JRPdfExporter exporter;
            JasperPrint jpPrint = this.jrPrint(reportFile, datas.getBytes("UTF-8"), parameters.getBytes("UTF-8"));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            switch (exportMode.toLowerCase()) {
                case "pdf": {
                    exporter = new JRPdfExporter();
                    exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)outputStream));
                    break;
                }
                case "excel": {
                    exporter = new JRXlsxExporter();
                    exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)outputStream));
                    break;
                }
                case "word": {
                    exporter = new JRDocxExporter();
                    exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)outputStream));
                    break;
                }
                case "csv": {
                    exporter = new JRCsvExporter();
                    exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput((OutputStream)outputStream));
                    break;
                }
                case "html": {
                    exporter = new HtmlExporter();
                    exporter.setExporterOutput((ExporterOutput)new SimpleHtmlExporterOutput((OutputStream)outputStream));
                    break;
                }
                case "xml": {
                    exporter = new JRXml4SwfExporter();
                    exporter.setExporterOutput((ExporterOutput)new SimpleXmlExporterOutput((OutputStream)outputStream));
                    break;
                }
                default: {
                    exporter = new JRPdfExporter();
                    exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)outputStream));
                }
            }
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jpPrint));
            exporter.exportReport();
            byte[] out = outputStream.toByteArray();
            return this.byteArrayToHex(out);
        }
        catch (JRException ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.byteArrayToHex(new byte[0]);
    }

    private JasperPrint jrPrint(String reportFile, byte[] datas, byte[] parameter) throws IOException {
        try {
            FileInputStream reportStream = new FileInputStream(reportFile);
            JsonDataSource jpData = new JsonDataSource((InputStream)new ByteArrayInputStream(datas));
            Map<String, Object> jpParam = this.getParameter(parameter);
            JasperReport jpReport = reportFile.endsWith(".jrxml") ? JasperCompileManager.compileReport((InputStream)reportStream) : (JasperReport)JRLoader.loadObject((InputStream)reportStream);
            JasperPrint jpPrint = JasperFillManager.fillReport((JasperReport)jpReport, jpParam, (JRDataSource)jpData);
            return jpPrint;
        }
        catch (JRException ex) {
            Logger.getLogger(iReport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    private Map<String, Object> getParameter(byte[] parameter) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap pms = (HashMap)objectMapper.readValue((InputStream)new ByteArrayInputStream(parameter), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        return pms;
    }

    public String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }
}

