const jwt = require('jsonwebtoken');
//const SECRET_KEY = "จริงๆแล้วก็ไม่รู้ว่าจะใส่อะไรดีที่เป็นความลับอะนะ";

function parseHeader(req) {
    var list = {},
        rc = req.headers.Authorization;
    var parts = rc.split(' ');
    list[parts.shift().trim()] = parts[1];
    return list;
}



module.exports = function (options) {
    options = options || ["*"];
    return function authenticate(req, res, next) {
        var oauth = parseHeader(req);
        if (oauth.JWT) {
            jwt.verify(oauth.JWT, req.SECRET_KEY, function (err, decode) {
                if (err) {
                    res.status(401).send("Unauthorized");
                } else {
                    if (options.includes("*") || options.includes(decode.role)) {
                        req.user = decode;
                        next();
                    } else {
                        res.status(403).send("Access Denied");
                    }
                }
            });
        } else {
            res.status(401).send("Unauthorized");
        }
    }

}