/*!
    @Product nylon-cli
    @title nylon-cli
    @version 1.0
    @author somchit chanudom
    @email somchit.c@nexts-corp.com
    @homepage http://www.nexts-corp.com
    @licenses http://www.nexts-corp.com/product/license
    @Copyright (c) 2016-2017
*/

var java = require('java');
//var logger = require('winston');
var async = require('async');
var fscan = require('./../common/fscan');
var looger;
module.exports = function (app) {
    logger=app.nylon.logger;
    try {
        fscan.scan(app.nylon.nylon_path + "/java", '.jar', true, function (err, jars) {
            if(!err){
                 async.each(jars, function (jar, next) {
                    try {
                        java.classpath.push(jar);
                        logger.info("Load Java Module :: " + jar.replace(app.nylon.nylon_path, ""));
                        next();
                    } catch (err) {
                        logger.error(err);
                        next();
                    }
                }, function (err) {
                    app.use(function (req, res, next) {
                        req.java = java;
                        next();
                    });
                    app.nylon.java=java;

                
                });
            }else{
                 logger.error(error);
            }
           
        });

    } catch (error) {
        logger.error(error);
       
    }

}