/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.List;
import net.sf.jasperreports.engine.CommonReturnValue;
import net.sf.jasperreports.engine.VariableReturnValue;
import net.sf.jasperreports.engine.design.JRDesignSubreportReturnValue;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.JRDistinctCountIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCommonReturnValue;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.type.CalculationEnum;

public class JRFillVariableReturnValue
extends JRFillCommonReturnValue
implements VariableReturnValue {
    protected final String fromVariable;

    public JRFillVariableReturnValue(VariableReturnValue returnValue, JRFillObjectFactory factory, BaseReportFiller filler) {
        super(returnValue, factory, filler);
        this.fromVariable = returnValue.getFromVariable();
    }

    protected JRFillVariableReturnValue(JRFillVariableReturnValue fillReturnValue, JRFillCloneFactory factory) {
        super(fillReturnValue, factory);
        this.fromVariable = fillReturnValue.fromVariable;
    }

    @Override
    public String getFromVariable() {
        return this.fromVariable;
    }

    @Override
    protected JRFillCommonReturnValue addDerivedReturnValue(CommonReturnValue parentReturnValue, List<JRFillCommonReturnValue> returnValueList, JRFillObjectFactory factory, BaseReportFiller filler) {
        JRFillVariableReturnValue returnValue = factory.getReturnValue((VariableReturnValue)parentReturnValue);
        returnValue.setDerived(true);
        return this.addReturnValue(returnValue, returnValueList, factory, filler);
    }

    @Override
    protected CommonReturnValue createHelperReturnValue(CommonReturnValue returnValue, String nameSuffix, CalculationEnum calculation) {
        JRDesignSubreportReturnValue helper = new JRDesignSubreportReturnValue();
        helper.setToVariable(returnValue.getToVariable() + nameSuffix);
        helper.setSubreportVariable(((VariableReturnValue)returnValue).getFromVariable());
        helper.setCalculation(calculation);
        helper.setIncrementerFactoryClassName(helper.getIncrementerFactoryClassName());
        return helper;
    }

    @Override
    protected CommonReturnValue createDistinctCountHelperReturnValue(CommonReturnValue returnValue) {
        JRDesignSubreportReturnValue helper = new JRDesignSubreportReturnValue();
        helper.setToVariable(returnValue.getToVariable() + "_DISTINCT_COUNT");
        helper.setSubreportVariable(((VariableReturnValue)returnValue).getFromVariable());
        helper.setCalculation(CalculationEnum.NOTHING);
        helper.setIncrementerFactoryClassName(JRDistinctCountIncrementerFactory.class.getName());
        return helper;
    }
}

