///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2014, Tavendo GmbH and/or collaborators. All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are met:
//
//  1. Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//  2. Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
//  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
//  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
//  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
//  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
//  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//  POSSIBILITY OF SUCH DAMAGE.
//
///////////////////////////////////////////////////////////////////////////////

var autobahn = require('autobahn');

var connection = new autobahn.Connection({
  url: 'ws://127.0.0.1:8000/ws',
  realm: 'realm1'
});

connection.onopen = function (session) {

  // SUBSCRIBE to a topic and receive events
  //
  function onhello(args, isBinary, ccc) {
    var msg = args[0];
    console.log(isBinary);
    console.log(ccc);
    var originaldata = new Buffer(msg, 'base64');   
    console.log("event for 'onhello' received: " + originaldata);
    console.log(args);
  }
  session.subscribe('com.example.test', onhello).then(
    function (sub) {
      console.log("subscribed to topic 'test'");
    },
    function (err) {
      console.log("failed to subscribed: " + err);
    }
  );


  // REGISTER a procedure for remote calling
  //
  /*function add2 (args) {
     var x = args[0];
     var y = args[1];
     console.log("add2() called with " + x + " and " + y);
     return x + y;
  }
  session.register('com.example.add2', add2).then(
     function (reg) {
        console.log("procedure add2() registered");
     },
     function (err) {
        console.log("failed to register procedure: " + err);
     }
  );


  // PUBLISH and CALL every second .. forever
  //
  var counter = 0;*/
  var k=0;
  setInterval(function () {
    
    session.call('com.test.add', [{x:2,y:3}]).then(
            function (res) {
                //for(var i=0;i<res.length;i++){
                //  console.log(res[i].app_name);
                //}
                console.log("Result:", res);
            }
        );
    
     session.publish('com.test.hello', ['Hello, world!::'+k]);
     k++;

  }, 3000);

};


connection.open();

