const work_dir = process.cwd();
const wamp_dir = "/app/ws";
var fscan = require('./../common/fscan');
var logger = require('winston');
var async = require('async');
//var wamp=null;

module.exports = function (app) {
    var autobahn = require('autobahn');
    console.log(app.nylon.config.ws);
    if (app.nylon.config.ws) {
        var connection = new autobahn.Connection(app.nylon.config.ws);
        
            var wamp = {
                callme: function (func) {
        
                    return function (args) {
                        var w_output = new autobahn.when.defer();
                        console.log(args);
                        var req = {
                            params: args[0],
                            body: args[0]
                            //r: app.nylon.r,
        
                        };
                        var res = {
                            json: function (data) {
                                w_output.resolve(data);
                            }
                        }
        
                        Object.assign(req, app.nylon.req);
                        Object.assign(res, app.nylon.res);
        
                        func(req, res);
                        return w_output.promise;
                    };
        
                },
                register: function (name, func) {
                    connection.session.register(name, this.callme(func)).then(
                        function (out) {
                            console.log("procedure " + name + " registered");
                        },
                        function (err) {
                            console.log("failed to register procedure: " + err);
                        }
                    )
        
                },
                call: function (name, values) {
                    var w_output = new autobahn.when.defer();
                    connection.session.call(name, values).then(
                        function (data) {
                            w_output.resolve(data);
                        }
                    );
                    return w_output.promise;
                },
        
                subscribe: function (name, func) {
                    connection.session.subscribe(name, func);
                },
                publish: function (name, data) {
                    connection.session.publish(name, [data]);
                }
        
            };
            //connection.
            connection.onopen = function (session) {
                console.log("ws open is ok");
        
        
        
        
        
                fscan.scan(work_dir + wamp_dir, ".ws.js", true, function (err, ws_list) {
                    async.each(ws_list, function (ws, next) {
                        logger.info("nylon start ws ::  " + ws);
                        require(ws)(wamp);
                        next();
                    }, function (err) {
                        console.log(err);
                        // callback(err, app);
                    });
                })
            }
            connection.open();
    }
}